/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.network.transformer;

import com.drmangotea.tfmg.base.TFMGUtils;
import com.drmangotea.tfmg.base.lang.TFMGTexts;
import com.drmangotea.tfmg.content.electricity.base.IElectric;
import com.drmangotea.tfmg.content.electricity.base.VoltageAlteringBlockEntity;
import com.drmangotea.tfmg.registry.TFMGBlocks;
import com.drmangotea.tfmg.registry.TFMGDataComponents;
import com.drmangotea.tfmg.registry.TFMGItems;
import java.util.ArrayList;
import java.util.List;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class TransformerBlockEntity
extends VoltageAlteringBlockEntity {
    boolean updateInFront = false;
    public ItemStack primaryCoil = ItemStack.EMPTY;
    public ItemStack secondaryCoil = ItemStack.EMPTY;
    public float coilRatio = 0.0f;

    public TransformerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public int getOutputVoltage() {
        return (int)((float)this.getData().getVoltage() * this.coilRatio);
    }

    @Override
    public int getOutputPower() {
        return this.coilRatio == 0.0f ? 0 : this.getPowerUsage();
    }

    @Override
    public void tick() {
        super.tick();
        if (this.updateInFront) {
            this.updateInFront();
            this.updateInFront = false;
        }
    }

    public void destroy() {
        ItemEntity item;
        super.destroy();
        BlockPos pos = this.getBlockPos();
        if (!this.primaryCoil.isEmpty()) {
            item = new ItemEntity(this.level, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), this.primaryCoil);
            this.level.addFreshEntity((Entity)item);
        }
        if (!this.secondaryCoil.isEmpty()) {
            item = new ItemEntity(this.level, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), this.secondaryCoil);
            this.level.addFreshEntity((Entity)item);
        }
    }

    @Override
    public int getPowerUsage() {
        IElectric be;
        Direction facing = this.getDirection();
        BlockEntity blockEntity = this.level.getBlockEntity(this.getBlockPos().relative(facing));
        if (blockEntity instanceof IElectric && (be = (IElectric)blockEntity).getData().getId() != this.data.getId() && be.hasElectricitySlot(facing.getOpposite())) {
            return Math.max(be.getNetworkPowerUsage(this), 0);
        }
        return 0;
    }

    public void updateCoils() {
        if (this.primaryCoil.get(TFMGDataComponents.COIL_TURNS) == null || this.secondaryCoil.get(TFMGDataComponents.COIL_TURNS) == null) {
            this.coilRatio = 0.0f;
            this.updateNextTick();
            this.updateInFront();
            return;
        }
        int primaryTurns = (Integer)this.primaryCoil.get(TFMGDataComponents.COIL_TURNS);
        int secondaryTurns = (Integer)this.secondaryCoil.get(TFMGDataComponents.COIL_TURNS);
        if (this.primaryCoil.isEmpty() || this.secondaryCoil.isEmpty() || primaryTurns < 50 || secondaryTurns < 50) {
            this.coilRatio = 0.0f;
            this.updateNextTick();
            this.updateInFront();
            return;
        }
        this.coilRatio = (float)secondaryTurns / (float)primaryTurns;
        this.updateNextTick();
        this.updateInFront();
    }

    @Override
    public boolean makeMultimeterTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.makeMultimeterTooltip(tooltip, isPlayerSneaking);
        if (this.coilRatio != 0.0f) {
            TFMGTexts.Multimeter.separator().forGoggles(tooltip);
            TFMGTexts.Multimeter.transformerRatio(this.coilRatio).forGoggles(tooltip, 1);
        }
        return true;
    }

    @Override
    public float resistance() {
        IElectric be;
        Direction facing = ((Direction)this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING)).getCounterClockWise();
        BlockEntity blockEntity = this.level.getBlockEntity(this.getBlockPos().relative(facing));
        if (blockEntity instanceof IElectric && (be = (IElectric)blockEntity).getData().getId() != this.data.getId() && be.hasElectricitySlot(facing.getOpposite())) {
            return Math.max(be.getNetworkResistance(), 0);
        }
        return 0.0f;
    }

    @Override
    public boolean hasElectricitySlot(Direction direction) {
        return direction == ((Direction)this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING)).getClockWise();
    }

    @Override
    public void onNetworkChanged(int oldVoltage, int oldPower) {
        super.onNetworkChanged(oldVoltage, oldPower);
        if (oldVoltage != this.getData().getVoltage() || oldPower != this.getPowerUsage()) {
            this.updateInFront = true;
        }
        this.sendStuff();
        this.setChanged();
    }

    @Override
    public void updateNetwork() {
        super.updateNetwork();
        this.updateInFront();
    }

    @Override
    public void remove() {
        super.remove();
        this.updateInFront();
    }

    @Override
    public void onPlaced() {
        super.onPlaced();
        this.updateInFront = true;
    }

    @Override
    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        if (!this.primaryCoil.isEmpty()) {
            compound.put("PrimaryCoil", this.primaryCoil.saveOptional(registries));
        }
        if (!this.secondaryCoil.isEmpty()) {
            compound.put("SecondaryCoil", this.secondaryCoil.save(registries));
        }
        compound.putFloat("CoilRation", this.coilRatio);
    }

    @Override
    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        if (compound.contains("PrimaryCoil")) {
            ItemStack.parse((HolderLookup.Provider)registries, (Tag)compound.getCompound("PrimaryCoil")).ifPresent(i -> {
                this.primaryCoil = i;
            });
        }
        if (compound.contains("SecondaryCoil")) {
            ItemStack.parse((HolderLookup.Provider)registries, (Tag)compound.getCompound("SecondaryCoil")).ifPresent(i -> {
                this.secondaryCoil = i;
            });
        }
        this.coilRatio = compound.getFloat("CoilRation");
    }

    public static List<Direction> getCoilDirections(Level level, BlockPos pos, BlockHitResult result) {
        Direction direction = (Direction)level.getBlockState(pos).getValue((Property)HorizontalDirectionalBlock.FACING);
        ArrayList<Direction> validDirections = new ArrayList<Direction>();
        validDirections.add(direction.getClockWise());
        validDirections.add(direction.getCounterClockWise());
        return IPlacementHelper.orderedByDistance((BlockPos)pos, (Vec3)result.getLocation(), validDirections);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void tickOutliner() {
        HitResult hitResult;
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.level == null || !((hitResult = mc.hitResult) instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult result = (BlockHitResult)hitResult;
        ClientLevel level = mc.level;
        BlockPos pos = result.getBlockPos();
        LocalPlayer player = mc.player;
        ItemStack heldItem = player.getMainHandItem();
        if (!TFMGBlocks.TRANSFORMER.has(level.getBlockState(pos))) {
            return;
        }
        if (!TFMGItems.ELECTROMAGNETIC_COIL.isIn(heldItem) && !heldItem.is(Items.AIR)) {
            return;
        }
        Direction direction = (Direction)level.getBlockState(pos).getValue((Property)HorizontalDirectionalBlock.FACING);
        Direction coilDirection = TransformerBlockEntity.getCoilDirections((Level)level, pos, result).get(0);
        Vec3 center = VecHelper.getCenterOf((Vec3i)pos);
        Vec3 corner1 = center.relative(coilDirection, 0.4375).relative(direction, 0.1875).relative(Direction.UP, 0.359375);
        Vec3 corner2 = center.relative(coilDirection, 0.0625).relative(direction.getOpposite(), 0.1875).relative(Direction.DOWN, 0.109375);
        TFMGUtils.createOutline(corner1, corner2, "CoilOutline", Color.rainbowColor((int)(AnimationTickHolder.getTicks() * 5)));
    }
}

