/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.configuration_wrench;

import com.drmangotea.tfmg.base.TFMGUtils;
import com.drmangotea.tfmg.content.electricity.base.IElectric;
import com.drmangotea.tfmg.content.electricity.configuration_wrench.ElectriciansWrenchScreen;
import com.drmangotea.tfmg.content.electricity.utilities.electric_motor.ElectricMotorBlockEntity;
import com.drmangotea.tfmg.content.engines.base.AbstractEngineBlockEntity;
import com.drmangotea.tfmg.registry.TFMGDataComponents;
import net.createmod.catnip.gui.ScreenOpener;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ElectriciansWrenchItem
extends Item {
    public ElectriciansWrenchItem(Item.Properties p_41383_) {
        super(p_41383_);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            if (level.isClientSide) {
                CatnipServices.PLATFORM.executeOnClientOnly(() -> () -> this.openWandGUI(itemStack, hand));
                player.getCooldowns().addCooldown((Item)this, 5);
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemStack);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemStack);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        if (player != null && !player.isShiftKeyDown()) {
            IElectric be;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof IElectric && (be = (IElectric)blockEntity).canBeInGroups()) {
                be.updateNextTick();
                be.sendStuff();
                be.getData().group.id = (Integer)context.getItemInHand().getOrDefault(TFMGDataComponents.CONFIGURATION_WRENCH_NUMBER, (Object)0);
                TFMGUtils.playSound(level, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, context.getPlayer());
                if (be instanceof ElectricMotorBlockEntity) {
                    ElectricMotorBlockEntity kineticBE = (ElectricMotorBlockEntity)be;
                    kineticBE.delayedUpdate = true;
                }
                return InteractionResult.SUCCESS;
            }
            blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof AbstractEngineBlockEntity) {
                be = (AbstractEngineBlockEntity)blockEntity;
                ((AbstractEngineBlockEntity)be).changeDirection();
                return InteractionResult.SUCCESS;
            }
        }
        return super.useOn(context);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openWandGUI(ItemStack itemStack, InteractionHand hand) {
        ScreenOpener.open((Screen)new ElectriciansWrenchScreen(itemStack, hand));
    }
}

