/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.camera;

import com.mojang.serialization.Codec;
import io.github.mortuusars.exposure.util.color.Color;
import io.github.mortuusars.exposure.world.camera.FilmColor;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.function.IntFunction;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum ExposureType implements StringRepresentable
{
    COLOR("color", Color.rgb(180, 130, 110), new FilmColor(1.2f, 0.96f, 0.75f, 1.0f)),
    BLACK_AND_WHITE("black_and_white", Color.WHITE, new FilmColor(1.0f, 1.0f, 1.0f, 1.0f));

    public static final Codec<ExposureType> CODEC;
    public static final StreamCodec<ByteBuf, ExposureType> STREAM_CODEC;
    private final String name;
    private final Color imageColor;
    private final FilmColor filmColor;

    private ExposureType(String name, Color imageColor, FilmColor filmColor) {
        this.name = name;
        this.imageColor = imageColor;
        this.filmColor = filmColor;
    }

    @NotNull
    public String getSerializedName() {
        return this.name;
    }

    public Color getImageColor() {
        return this.imageColor;
    }

    public FilmColor getFilmColor() {
        return this.filmColor;
    }

    public static Optional<ExposureType> byName(@Nullable String name) {
        for (ExposureType type : ExposureType.values()) {
            if (!type.name().equals(name)) continue;
            return Optional.of(type);
        }
        return Optional.empty();
    }

    static {
        CODEC = StringRepresentable.fromEnum(ExposureType::values);
        STREAM_CODEC = ByteBufCodecs.idMapper((IntFunction)ByIdMap.continuous(Enum::ordinal, (Object[])ExposureType.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO), Enum::ordinal);
    }
}

