/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.network.packet.serverbound;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.network.packet.Packet;
import io.github.mortuusars.exposure.world.item.AlbumItem;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public record AlbumSignC2SP(int slot, String title, String author) implements Packet
{
    public static final ResourceLocation ID = Exposure.resource("album_sign");
    public static final CustomPacketPayload.Type<AlbumSignC2SP> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<FriendlyByteBuf, AlbumSignC2SP> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, AlbumSignC2SP::slot, (StreamCodec)ByteBufCodecs.STRING_UTF8, AlbumSignC2SP::title, (StreamCodec)ByteBufCodecs.STRING_UTF8, AlbumSignC2SP::author, AlbumSignC2SP::new);

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    @Override
    public boolean handle(PacketFlow flow, Player player) {
        Preconditions.checkState((player != null ? 1 : 0) != 0, (Object)"Cannot handle packet: Player was null");
        ItemStack albumStack = player.getInventory().getItem(this.slot());
        Item item = albumStack.getItem();
        if (item instanceof AlbumItem) {
            AlbumItem albumItem = (AlbumItem)item;
            ItemStack signedAlbumStack = albumItem.sign(albumStack, this.title(), this.author());
            player.getInventory().setItem(this.slot(), signedAlbumStack);
            player.level().playSound(null, (Entity)player, Exposure.SoundEvents.WRITE.get(), SoundSource.PLAYERS, 0.8f, 1.0f);
        }
        return true;
    }
}

