/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.mortuusars.exposure.commands.argument.ShaderLocationArgument;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.network.packet.clientbound.ShaderApplyS2CP;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class ShaderCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"shader").requires(stack -> stack.hasPermission(2))).then(Commands.literal((String)"apply").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"shader_location", (ArgumentType)new ShaderLocationArgument()).executes(ShaderCommand::applyShader))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(ShaderCommand::removeShader))));
    }

    private static int applyShader(CommandContext<CommandSourceStack> context) {
        ResourceLocation shaderLocation = ResourceLocationArgument.getId(context, (String)"shader_location");
        for (ServerPlayer targetPlayer : ShaderCommand.getTargetPlayers(context)) {
            Packets.sendToClient(new ShaderApplyS2CP(shaderLocation), targetPlayer);
        }
        return 0;
    }

    private static int removeShader(CommandContext<CommandSourceStack> context) {
        for (ServerPlayer targetPlayer : ShaderCommand.getTargetPlayers(context)) {
            Packets.sendToClient(ShaderApplyS2CP.REMOVE, targetPlayer);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"command.exposure.shader.removed"), false);
        }
        return 0;
    }

    private static List<ServerPlayer> getTargetPlayers(CommandContext<CommandSourceStack> context) {
        try {
            return new ArrayList<ServerPlayer>(EntityArgument.getPlayers(context, (String)"targets"));
        }
        catch (CommandSyntaxException e) {
            return Collections.emptyList();
        }
    }
}

