/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import io.github.mortuusars.exposure.util.Rect2f;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class GuiUtil {
    public static void blit(PoseStack poseStack, Rect2f rect, int u, int v, int textureWidth, int textureHeight, float zOffset) {
        GuiUtil.blit(null, poseStack, rect, u, v, textureWidth, textureHeight, zOffset);
    }

    public static void blit(@Nullable ResourceLocation texture, PoseStack poseStack, Rect2f rect, int u, int v, int textureWidth, int textureHeight, float zOffset) {
        GuiUtil.blit(texture, poseStack, rect.x, rect.y, rect.width, rect.height, u, v, textureWidth, textureHeight, zOffset);
    }

    public static void blit(PoseStack poseStack, float x, float y, float width, float height, int u, int v, int textureWidth, int textureHeight, float zOffset) {
        GuiUtil.blit(null, poseStack, x, y, width, height, u, v, textureWidth, textureHeight, zOffset);
    }

    public static void blit(@Nullable ResourceLocation texture, PoseStack poseStack, float x, float y, float width, float height, int u, int v, int textureWidth, int textureHeight, float zOffset) {
        GuiUtil.blit(texture, poseStack, x, x + width, y, y + height, zOffset, (float)u / (float)textureWidth, ((float)u + width) / (float)textureWidth, (float)v / (float)textureHeight, ((float)v + height) / (float)textureHeight);
    }

    public static void blit(PoseStack poseStack, float minX, float maxX, float minY, float maxY, float zOffset, float minU, float maxU, float minV, float maxV) {
        GuiUtil.blit(null, poseStack, minX, maxX, minY, maxY, zOffset, minU, maxU, minV, maxV);
    }

    private static void blit(@Nullable ResourceLocation texture, PoseStack poseStack, float minX, float maxX, float minY, float maxY, float zOffset, float minU, float maxU, float minV, float maxV) {
        if (texture != null) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        }
        Matrix4f matrix = poseStack.last().pose();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferBuilder.addVertex(matrix, minX, maxY, zOffset).setUv(minU, maxV);
        bufferBuilder.addVertex(matrix, maxX, maxY, zOffset).setUv(maxU, maxV);
        bufferBuilder.addVertex(matrix, maxX, minY, zOffset).setUv(maxU, minV);
        bufferBuilder.addVertex(matrix, minX, minY, zOffset).setUv(minU, minV);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
    }

    public static void drawRect(GuiGraphics guiGraphics, Rect2f rect, int color) {
        GuiUtil.drawRect(guiGraphics, rect.x, rect.y, rect.width, rect.height, color);
    }

    public static void drawRect(GuiGraphics guiGraphics, float x, float y, float width, float height, int color) {
        GuiUtil.drawRect(guiGraphics.pose(), x, y, x + width, y + height, color);
    }

    public static void drawRect(PoseStack poseStack, float minX, float minY, float maxX, float maxY, int color) {
        float temp;
        if (minX < maxX) {
            temp = minX;
            minX = maxX;
            maxX = temp;
        }
        if (minY < maxY) {
            temp = minY;
            minY = maxY;
            maxY = temp;
        }
        Matrix4f matrix = poseStack.last().pose();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        bufferBuilder.addVertex(matrix, minX, maxY, 0.0f).setColor(color);
        bufferBuilder.addVertex(matrix, maxX, maxY, 0.0f).setColor(color);
        bufferBuilder.addVertex(matrix, maxX, minY, 0.0f).setColor(color);
        bufferBuilder.addVertex(matrix, minX, minY, 0.0f).setColor(color);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
    }

    public static void renderScrollingString(GuiGraphics guiGraphics, Font font, Component text, int x, int y, int width, int color) {
        Objects.requireNonNull(font);
        GuiUtil.renderScrollingString(guiGraphics, font, text, x, y, x + width, y + 9, color);
    }

    public static void renderScrollingString(GuiGraphics guiGraphics, Font font, Component text, int minX, int minY, int maxX, int maxY, int color) {
        GuiUtil.renderScrollingString(guiGraphics, font, text, (minX + maxX) / 2, minX, minY, maxX, maxY, color);
    }

    public static void renderScrollingString(GuiGraphics guiGraphics, Font font, Component text, int centerX, int minX, int minY, int maxX, int maxY, int color) {
        int fontWidth = font.width((FormattedText)text);
        int y = (minY + maxY - 9) / 2 + 1;
        int width = maxX - minX;
        if (fontWidth > width) {
            int remaining = fontWidth - width;
            double d = (double)Util.getMillis() / 400.0;
            double e = Math.max((double)remaining * 0.5, 3.0);
            double f = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * d / e)) / 2.0 + 0.5;
            double g = Mth.lerp((double)f, (double)0.0, (double)remaining);
            guiGraphics.enableScissor(minX, minY, maxX, maxY);
            guiGraphics.drawString(font, text, minX - (int)g, y, color, false);
            guiGraphics.disableScissor();
        } else {
            int l = Mth.clamp((int)centerX, (int)(minX + fontWidth / 2), (int)(maxX - fontWidth / 2));
            guiGraphics.drawCenteredString(font, text, l, y, color);
        }
    }
}

