/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.image.modifier.pixel;

import io.github.mortuusars.exposure.client.image.modifier.pixel.PixelEffect;
import net.minecraft.util.FastColor;

public class MultiplyEffect
implements PixelEffect {
    protected final int multiplyColor;

    public MultiplyEffect(int multiplyColor) {
        this.multiplyColor = multiplyColor;
    }

    @Override
    public String getIdentifier() {
        return this.multiplyColor != 0 ? "multiply-" + Integer.toHexString(this.multiplyColor) : "";
    }

    @Override
    public int modify(int colorARGB) {
        if (this.multiplyColor == 0) {
            return colorARGB;
        }
        int alpha = FastColor.ARGB32.alpha((int)colorARGB);
        int red = FastColor.ARGB32.red((int)colorARGB);
        int green = FastColor.ARGB32.green((int)colorARGB);
        int blue = FastColor.ARGB32.blue((int)colorARGB);
        int tintAlpha = FastColor.ARGB32.alpha((int)colorARGB);
        int tintRed = FastColor.ARGB32.red((int)colorARGB);
        int tintGreen = FastColor.ARGB32.green((int)colorARGB);
        int tintBlue = FastColor.ARGB32.blue((int)colorARGB);
        alpha = Math.min(255, alpha * tintAlpha / 255);
        red = Math.min(255, red * tintRed / 255);
        green = Math.min(255, green * tintGreen / 255);
        blue = Math.min(255, blue * tintBlue / 255);
        return FastColor.ARGB32.color((int)alpha, (int)green, (int)red, (int)blue);
    }
}

