/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.infrastructure.gametest.tests;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllDataComponents;
import com.simibubi.create.content.redstone.thresholdSwitch.ThresholdSwitchBlockEntity;
import com.simibubi.create.content.schematics.SchematicExport;
import com.simibubi.create.content.schematics.SchematicItem;
import com.simibubi.create.content.schematics.cannon.SchematicannonBlockEntity;
import com.simibubi.create.foundation.utility.CreatePaths;
import com.simibubi.create.infrastructure.gametest.CreateGameTestHelper;
import com.simibubi.create.infrastructure.gametest.GameTestGroup;
import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedstoneLampBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.Property;

@GameTestGroup(path="misc")
public class TestMisc {
    @GameTest(template="schematicannon", timeoutTicks=300)
    public static void schematicannon(CreateGameTestHelper helper) {
        BlockPos whiteEndBottom = helper.absolutePos(new BlockPos(5, 2, 1));
        BlockPos redEndTop = helper.absolutePos(new BlockPos(5, 4, 7));
        ServerLevel level = helper.getLevel();
        SchematicExport.saveSchematic(CreatePaths.UPLOADED_SCHEMATICS_DIR.resolve("Deployer"), "schematicannon_gametest", true, (Level)level, whiteEndBottom, redEndTop);
        ItemStack schematic = SchematicItem.create((Level)level, "schematicannon_gametest.nbt", "Deployer");
        BlockPos anchor = helper.absolutePos(new BlockPos(1, 2, 1));
        schematic.set(AllDataComponents.SCHEMATIC_DEPLOYED, (Object)true);
        schematic.set(AllDataComponents.SCHEMATIC_ANCHOR, (Object)anchor);
        BlockPos cannonPos = new BlockPos(3, 2, 6);
        SchematicannonBlockEntity cannon = (SchematicannonBlockEntity)helper.getBlockEntity((BlockEntityType)AllBlockEntityTypes.SCHEMATICANNON.get(), cannonPos);
        cannon.inventory.setStackInSlot(0, schematic);
        cannon.state = SchematicannonBlockEntity.State.RUNNING;
        cannon.statusMsg = "running";
        helper.succeedWhen(() -> {
            if (cannon.state != SchematicannonBlockEntity.State.STOPPED) {
                helper.fail("Schematicannon not done");
            }
            BlockPos lastBlock = new BlockPos(1, 4, 7);
            helper.assertBlockPresent(Blocks.RED_WOOL, lastBlock);
        });
    }

    @GameTest(template="shearing")
    public static void shearing(CreateGameTestHelper helper) {
        BlockPos sheepPos = new BlockPos(2, 1, 2);
        Sheep sheep = (Sheep)helper.getFirstEntity(EntityType.SHEEP, sheepPos);
        sheep.shear(SoundSource.NEUTRAL);
        helper.succeedWhen(() -> helper.assertItemEntityPresent(Items.WHITE_WOOL, sheepPos, 2.0));
    }

    @GameTest(template="smart_observer_blocks")
    public static void smartObserverBlocks(CreateGameTestHelper helper) {
        BlockPos lever = new BlockPos(2, 2, 1);
        BlockPos leftLamp = new BlockPos(3, 4, 3);
        BlockPos rightLamp = new BlockPos(1, 4, 3);
        helper.pullLever(lever);
        helper.succeedWhen(() -> {
            helper.assertBlockProperty(leftLamp, (Property)RedstoneLampBlock.LIT, Boolean.valueOf(true));
            helper.assertBlockProperty(rightLamp, (Property)RedstoneLampBlock.LIT, Boolean.valueOf(false));
        });
    }

    @GameTest(template="threshold_switch_pulley")
    public static void thresholdSwitchPulley(CreateGameTestHelper helper) {
        BlockPos lever = new BlockPos(3, 7, 1);
        BlockPos switchPos = new BlockPos(1, 6, 1);
        BlockPos finalPos = new BlockPos(2, 2, 1);
        helper.runAfterDelay(10L, () -> helper.pullLever(lever));
        helper.succeedWhen(() -> {
            int expectedLevel;
            ThresholdSwitchBlockEntity switchBe = (ThresholdSwitchBlockEntity)helper.getBlockEntity((BlockEntityType)AllBlockEntityTypes.THRESHOLD_SWITCH.get(), switchPos);
            int level = switchBe.getStockLevel();
            if (level != (expectedLevel = helper.absolutePos(finalPos).getY())) {
                helper.fail("Unexpected level: " + level);
            }
        });
    }

    @GameTest(template="netherite_backtank", timeoutTicks=200)
    public static void netheriteBacktank(CreateGameTestHelper helper) {
        BlockPos lava = new BlockPos(2, 2, 3);
        BlockPos zombieSpawn = lava.above(2);
        BlockPos armorStandPos = new BlockPos(2, 2, 1);
        helper.runAtTickTime(5L, () -> {
            Zombie zombie = (Zombie)helper.spawn(EntityType.ZOMBIE, zombieSpawn);
            ArmorStand armorStand = (ArmorStand)helper.getFirstEntity(EntityType.ARMOR_STAND, armorStandPos);
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                zombie.setItemSlot(slot, armorStand.getItemBySlot(slot).copy());
            }
        });
        helper.succeedWhen(() -> {
            helper.assertSecondsPassed(9);
            helper.assertEntityPresent(EntityType.ZOMBIE, lava);
        });
    }
}

