/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_paintings;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import java.util.UUID;
import net.conczin.immersive_paintings.Main;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public record Painting(int version, int width, int height, int resolution, String name, String author, UUID authorUUID, Type type, EnumSet<Flag> flags, String hash) {
    public static final Codec<Painting> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.INT.fieldOf("version").forGetter(Painting::version), (App)Codec.INT.fieldOf("width").forGetter(Painting::width), (App)Codec.INT.fieldOf("height").forGetter(Painting::height), (App)Codec.INT.fieldOf("resolution").forGetter(Painting::resolution), (App)Codec.STRING.fieldOf("name").forGetter(Painting::name), (App)Codec.STRING.fieldOf("author").forGetter(Painting::author), (App)UUIDUtil.CODEC.fieldOf("authorUUID").forGetter(Painting::authorUUID), (App)Type.CODEC.fieldOf("type").forGetter(Painting::type), (App)Flag.CODEC.fieldOf("flags").forGetter(Painting::flags), (App)Codec.STRING.fieldOf("hash").forGetter(Painting::hash)).apply((Applicative)i, Painting::new));
    public static final StreamCodec<ByteBuf, Painting> STREAM_CODEC = ByteBufCodecs.fromCodec(CODEC);
    public static final ResourceLocation DEFAULT_IDENTIFIER = Main.locate("textures/block/frame/canvas.png");

    public Painting(int width, int height, int resolution, String name, String author, UUID authorUUID, Type type, EnumSet<Flag> flags, String hash) {
        this(1, width, height, resolution, name, author, authorUUID, type, flags, hash);
    }

    public ResourceLocation location() {
        switch (this.type.ordinal()) {
            case 0: {
                return Main.locate("datapack/" + this.hash);
            }
            case 1: {
                return Main.locate("xerca/" + this.hash);
            }
        }
        return Main.locate(this.authorUUID.toString() + "/" + this.hash);
    }

    public boolean is(Type t) {
        return this.type().equals((Object)t);
    }

    public boolean has(Flag flag) {
        return this.flags().contains((Object)flag);
    }

    public Painting withHash(String newHash) {
        return new Painting(this.width(), this.height(), this.resolution(), this.name(), this.author(), this.authorUUID(), this.type(), this.flags(), newHash);
    }

    public static enum Type implements StringRepresentable
    {
        DATAPACK,
        XERCA,
        PAINTING;

        public static final Codec<Type> CODEC;

        @NotNull
        public String getSerializedName() {
            return this.name();
        }

        static {
            CODEC = StringRepresentable.fromValues(Type::values);
        }
    }

    public static enum Flag {
        HIDDEN(1L),
        NSFW(2L),
        GRAFFITI(4L);

        private final long bits;
        public static final PrimitiveCodec<EnumSet<Flag>> CODEC;
        public static final StreamCodec<ByteBuf, EnumSet<Flag>> STREAM_CODEC;

        private Flag(long bits) {
            this.bits = bits;
        }

        static {
            CODEC = new PrimitiveCodec<EnumSet<Flag>>(){

                public <T> DataResult<EnumSet<Flag>> read(DynamicOps<T> ops, T input) {
                    DataResult result = ops.getNumberValue(input).map(Number::longValue);
                    if (result.isError()) {
                        return DataResult.error(() -> "No long provided for reading FlagSet");
                    }
                    long l = (Long)result.getOrThrow();
                    EnumSet<Flag> flags = EnumSet.noneOf(Flag.class);
                    for (Flag f : Flag.values()) {
                        if ((l & f.bits) == 0L) continue;
                        flags.add(f);
                    }
                    return DataResult.success(flags);
                }

                public <T> T write(DynamicOps<T> ops, EnumSet<Flag> value) {
                    long l = value.stream().map(f -> f.bits).reduce(0L, (a, b) -> a | b);
                    return (T)ops.createLong(l);
                }

                public String toString() {
                    return "Flags";
                }
            };
            STREAM_CODEC = ByteBufCodecs.fromCodec(CODEC);
        }
    }

    public static enum Size {
        FULL,
        HALF,
        QUARTER,
        EIGHTH,
        THUMBNAIL,
        NSFW;

    }
}

