/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism_integrations.jade.provider;

import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.blockentity.TotemBlockEntity;
import de.teamlapen.vampirism_integrations.jade.JadePlugin;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public enum TotemProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;


    public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        CompoundTag tag;
        if (blockAccessor.getServerData().contains("totem", 10) && (tag = blockAccessor.getServerData().getCompound("totem")).contains("controllingFaction")) {
            IFaction capturing;
            IFaction controlling = tag.contains("controllingFaction") ? VampirismAPI.factionRegistry().getFactionByID(ResourceLocation.parse((String)tag.getString("controllingFaction"))) : null;
            IFaction iFaction = capturing = tag.contains("capturingFaction") ? VampirismAPI.factionRegistry().getFactionByID(ResourceLocation.parse((String)tag.getString("capturingFaction"))) : null;
            if (capturing != null) {
                if (controlling != null) {
                    iTooltip.add((Component)Component.translatable((String)"text.vampirism_integrations.defending").append(": ").append((Component)controlling.getNamePlural().plainCopy().withStyle(s -> s.withColor(controlling.getChatColor()))));
                }
                iTooltip.add((Component)Component.translatable((String)"text.vampirism_integrations.attacking").append(": ").append((Component)capturing.getNamePlural().plainCopy().withStyle(s -> s.withColor(capturing.getChatColor()))));
            } else if (controlling != null) {
                iTooltip.add((Component)Component.translatable((String)"text.vampirism_integrations.controlling").append(": ").append((Component)controlling.getNamePlural().plainCopy().withStyle(s -> s.withColor(controlling.getChatColor()))));
            }
        }
    }

    public void appendServerData(CompoundTag tag, BlockAccessor blockAccessor) {
        BlockEntity blockEntity = blockAccessor.getBlockEntity();
        if (blockEntity instanceof TotemBlockEntity) {
            TotemBlockEntity totem = (TotemBlockEntity)blockEntity;
            CompoundTag compoundTag = new CompoundTag();
            Optional.ofNullable(totem.getControllingFaction()).map(IFaction::getID).ifPresent(id -> compoundTag.putString("controllingFaction", id.toString()));
            Optional.ofNullable(totem.getCapturingFaction()).map(IFaction::getID).ifPresent(id -> compoundTag.putString("capturingFaction", id.toString()));
            tag.put("totem", (Tag)compoundTag);
        }
    }

    public ResourceLocation getUid() {
        return JadePlugin.TOTEM;
    }
}

