/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism_integrations.crafttweaker;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.items.IWeaponTableRecipe;
import de.teamlapen.vampirism.core.ModRecipes;
import de.teamlapen.vampirism.recipes.ShapedWeaponTableRecipe;
import de.teamlapen.vampirism.recipes.ShapelessWeaponTableRecipe;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="mods/vampirism/WeaponTableRecipe")
@ZenCodeType.Name(value="mods.vampirism.WeaponTableRecipe")
public class CTWeaponTableRecipeManager
implements IRecipeManager<IWeaponTableRecipe> {
    public RecipeType<IWeaponTableRecipe> getRecipeType() {
        return (RecipeType)ModRecipes.WEAPONTABLE_CRAFTING_TYPE.get();
    }

    @ZenCodeType.Method
    public void addShapeless(String recipePath, CraftingBookCategory category, IItemStack result, IIngredient[] ingredients, int level, int lava, ISkill<?>[] skills) {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"crafttweaker", (String)recipePath);
        NonNullList nonnulllist = NonNullList.create();
        nonnulllist.addAll(Arrays.stream(ingredients).map(IIngredient::asVanillaIngredient).toList());
        ShapelessWeaponTableRecipe recipe = new ShapelessWeaponTableRecipe("", category, nonnulllist, result.getInternal(), level, lava, Arrays.asList(skills));
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, new RecipeHolder(id, (Recipe)recipe), "shapeless"));
    }

    @ZenCodeType.Method
    public void addShaped(String recipePath, CraftingBookCategory category, IItemStack result, IIngredient[][] ingredients, int level, int lava, ISkill<?>[] skills) {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"crafttweaker", (String)recipePath);
        NonNullList nonnulllist = NonNullList.create();
        nonnulllist.addAll(Arrays.stream(ingredients).flatMap(Arrays::stream).map(IIngredient::asVanillaIngredient).toList());
        ShapedRecipePattern shapedRecipePattern = new ShapedRecipePattern(Math.clamp((long)Arrays.stream(ingredients).mapToInt(x -> ((IIngredient[])x).length).max().orElseThrow(), 1, 4), ingredients.length, NonNullList.of((Object)Ingredient.EMPTY, (Object[])((Ingredient[])Arrays.stream(ingredients).flatMap(x -> Arrays.stream(x).map(IIngredient::asVanillaIngredient)).toArray(Ingredient[]::new))), Optional.empty());
        ShapedWeaponTableRecipe recipe = new ShapedWeaponTableRecipe("", category, shapedRecipePattern, result.getInternal(), level, Arrays.asList(skills), lava);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, new RecipeHolder(id, (Recipe)recipe), "shaped"));
    }
}

