/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism_integrations.coldsweat;

import de.teamlapen.lib.lib.util.IInitListener;
import de.teamlapen.vampirism_integrations.coldsweat.ColdSweatEventHandler;
import de.teamlapen.vampirism_integrations.util.IModCompat;
import net.neoforged.fml.event.lifecycle.ParallelDispatchEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.common.NeoForge;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.Nullable;

public class ColdSweatCompat
implements IModCompat {
    public static final String ID = "cold_sweat";
    public static ModConfigSpec.BooleanValue enableTemperatureVampires;
    public static ModConfigSpec.DoubleValue vampireColdResistance;
    public static ModConfigSpec.DoubleValue vampireBurningPointModifier;

    @Override
    public void buildConfig(ModConfigSpec.Builder builder) {
        enableTemperatureVampires = builder.comment("Grant vampires cold resistance, but decrease heat resistance").define("enableTemperatureVampires", true);
        vampireColdResistance = builder.comment("Increase cold resistance for vampires by this degree celsius").defineInRange("vampireColdResistance", 20.0, 0.0, 100.0);
        vampireBurningPointModifier = builder.comment("Decrease the burning point of vampires by this factor").defineInRange("vampireBurningPointModifier", 0.7, 0.0, 1.0);
    }

    @Override
    public String getModID() {
        return ID;
    }

    @Override
    @Nullable
    public String getAcceptedVersionRange() {
        return "[2.2.3,)";
    }

    public void onInitStep(IInitListener.Step step, ParallelDispatchEvent event) {
        if (step == IInitListener.Step.COMMON_SETUP) {
            try {
                NeoForge.EVENT_BUS.register((Object)new ColdSweatEventHandler());
            }
            catch (Exception e) {
                LogManager.getLogger().error("Failed to register cold sweat event handler", (Throwable)e);
            }
        }
    }
}

