/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.client.recipebook;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.EnumSet;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public enum CookingPotRecipeBookTab implements StringRepresentable
{
    MEALS("meals"),
    DRINKS("drinks"),
    MISC("misc");

    public static final Codec<CookingPotRecipeBookTab> CODEC;
    public final String name;

    private CookingPotRecipeBookTab(String name) {
        this.name = name;
    }

    public static CookingPotRecipeBookTab findByName(String name) {
        for (CookingPotRecipeBookTab value : CookingPotRecipeBookTab.values()) {
            if (!value.name.equals(name)) continue;
            return value;
        }
        return null;
    }

    public String toString() {
        return this.name;
    }

    @NotNull
    public String getSerializedName() {
        return this.name;
    }

    static {
        CODEC = Codec.STRING.flatXmap(s -> {
            CookingPotRecipeBookTab tab = CookingPotRecipeBookTab.findByName(s);
            if (tab == null) {
                return DataResult.error(() -> "Optional field 'recipe_book_tab' does not match any valid tab. If defined, must be one of the following: " + String.valueOf(EnumSet.allOf(CookingPotRecipeBookTab.class)));
            }
            return DataResult.success((Object)((Object)tab));
        }, tab -> DataResult.success((Object)tab.toString()));
    }
}

