/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbbackups.client;

import dev.ftb.mods.ftbbackups.archival.ArchivePluginManager;
import dev.ftb.mods.ftbbackups.config.ArchivalPluginConfig;
import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.AbstractButtonListScreen;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class SelectArchivalPluginScreen
extends AbstractButtonListScreen {
    private final ArchivalPluginConfig config;
    private final ConfigCallback callback;

    public SelectArchivalPluginScreen(ArchivalPluginConfig config, ConfigCallback callback) {
        this.config = config;
        this.callback = callback;
        this.setTitle((Component)Component.translatable((String)"ftbbackups3.general.archival_plugin"));
        this.showBottomPanel(false);
        this.showCloseButton(true);
    }

    public void addButtons(Panel panel) {
        ArchivePluginManager.clientInstance().plugins().keySet().forEach(k -> panel.add((Widget)new PluginButton(panel, (ResourceLocation)k)));
    }

    public boolean onClosedByKey(Key key) {
        if (super.onClosedByKey(key)) {
            this.callback.save(false);
            return true;
        }
        return false;
    }

    protected void doCancel() {
        this.callback.save(false);
    }

    protected void doAccept() {
        this.callback.save(true);
    }

    private class PluginButton
    extends SimpleTextButton {
        private final ResourceLocation value;

        PluginButton(Panel panel, ResourceLocation value) {
            super(panel, (Component)Component.literal((String)value.toString()), (Icon)Color4I.empty());
            this.value = value;
        }

        public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
            if (this.isMouseOver) {
                Color4I.WHITE.withAlpha(30).draw(graphics, x, y, w, h);
            }
            Color4I.GRAY.withAlpha(40).draw(graphics, x, y + h, w, 1);
        }

        public void onClicked(MouseButton mouseButton) {
            this.playClickSound();
            SelectArchivalPluginScreen.this.config.setCurrentValue(this.value);
            SelectArchivalPluginScreen.this.callback.save(true);
        }
    }
}

