/*
 * Decompiled with CFR 0.152.
 */
package com.ilexiconn.llibrary.client.util;

import com.mojang.blaze3d.vertex.VertexConsumer;
import org.joml.Matrix3f;
import org.joml.Vector3f;

public class ClientUtils {
    private static long lastUpdate = System.currentTimeMillis();

    public static void updateLast() {
        lastUpdate = System.currentTimeMillis();
    }

    public static float updateValue(float current, float target) {
        return ClientUtils.updateValue(current, target, 0.5f);
    }

    public static float updateValue(float current, float target, float factor) {
        float times = (float)(System.currentTimeMillis() - lastUpdate) / 16.666666f;
        float off = target - current;
        off = off > 0.01f || off < -0.01f ? off * (float)Math.pow(factor, times) : 0.0f;
        return target - off;
    }

    public static float interpolate(float prev, float current, float partialTicks) {
        return prev + partialTicks * (current - prev);
    }

    public static float interpolateRotation(float prev, float current, float partialTicks) {
        float shortest = ((current - prev) % 360.0f + 540.0f) % 360.0f - 180.0f;
        return prev + shortest * partialTicks;
    }

    public static VertexConsumer transformNormals(VertexConsumer consumer, Matrix3f normals, float x, float y, float z) {
        Vector3f transformed = ClientUtils.transformNormals(normals, x, y, z);
        return consumer.setNormal(transformed.x(), transformed.y(), transformed.z());
    }

    public static Vector3f transformNormals(Matrix3f normals, float x, float y, float z) {
        Vector3f input = new Vector3f(x, y, z);
        return normals.transform(input);
    }
}

