/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.umvuthana;

import com.google.common.base.Defaults;
import java.util.EnumMap;
import java.util.Locale;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;

public enum MaskType {
    FURY((Holder<MobEffect>)MobEffects.DAMAGE_BOOST, 0.9f, 2.0f, true),
    FEAR((Holder<MobEffect>)MobEffects.MOVEMENT_SPEED),
    RAGE((Holder<MobEffect>)MobEffects.DIG_SPEED),
    BLISS((Holder<MobEffect>)MobEffects.JUMP),
    MISERY((Holder<MobEffect>)MobEffects.DAMAGE_RESISTANCE),
    FAITH((Holder<MobEffect>)MobEffects.HEALTH_BOOST, 0.9f, 2.0f, false);

    public static final int COUNT;
    public final Holder<MobEffect> potion;
    public final float entityWidth;
    public final float entityHeight;
    public final boolean canBlock;
    public final String name;

    private MaskType(Holder<MobEffect> potion) {
        this(potion, 0.8f, 1.8f, false);
    }

    private MaskType(Holder<MobEffect> potion, float entityWidth, float entityHeight, boolean canBlock) {
        this.potion = potion;
        this.entityWidth = entityWidth;
        this.entityHeight = entityHeight;
        this.canBlock = canBlock;
        this.name = this.name().toLowerCase(Locale.ENGLISH);
    }

    public static MaskType from(int id) {
        if (id < 0 || id >= COUNT) {
            return MISERY;
        }
        return MaskType.values()[id];
    }

    public static <T> EnumMap<MaskType, T> newEnumMap(Class<T> type, T ... defaultValues) {
        EnumMap<MaskType, Object> map = new EnumMap<MaskType, Object>(MaskType.class);
        MaskType[] masks = MaskType.values();
        for (int i = 0; i < masks.length; ++i) {
            map.put(masks[i], i >= 0 && i < defaultValues.length ? defaultValues[i] : Defaults.defaultValue(type));
        }
        return map;
    }

    static {
        COUNT = MaskType.values().length;
    }
}

