/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.effects.geomancy;

import com.bobmowzie.mowziesmobs.client.particle.ParticleHandler;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleBase;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleComponent;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleRotation;
import com.bobmowzie.mowziesmobs.server.ability.AbilityHandler;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityCameraShake;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityBoulderBase;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityEarthSpike;
import com.bobmowzie.mowziesmobs.server.entity.effects.geomancy.EntityGeomancyBase;
import com.bobmowzie.mowziesmobs.server.entity.sculptor.EntitySculptor;
import com.bobmowzie.mowziesmobs.server.potion.EffectGeomancy;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import software.bernie.geckolib.animation.AnimatableManager;

public class EntityBoulderProjectile
extends EntityBoulderBase {
    protected final List<Entity> ridingEntities = new ArrayList<Entity>();
    protected boolean travelling = false;
    protected float speed = 1.5f;
    protected int damage = 10;
    private boolean didShootParticles = false;
    private static final EntityDataAccessor<Vector3f> SHOOT_DIRECTION = SynchedEntityData.defineId(EntityBoulderProjectile.class, (EntityDataSerializer)EntityDataSerializers.VECTOR3);
    private List<Entity> hitEntities = new ArrayList<Entity>();

    public EntityBoulderProjectile(EntityType<? extends EntityBoulderProjectile> type, Level world) {
        super((EntityType<? extends EntityBoulderBase>)type, world);
    }

    public EntityBoulderProjectile(EntityType<? extends EntityBoulderProjectile> type, Level world, LivingEntity caster, BlockState blockState, BlockPos pos, EntityGeomancyBase.GeomancyTier tier) {
        super(type, world, caster, blockState, pos, tier);
    }

    @Override
    public void setSizeParams() {
        super.setSizeParams();
        EntityGeomancyBase.GeomancyTier size = this.getTier();
        if (size == EntityGeomancyBase.GeomancyTier.MEDIUM) {
            this.damage = 14;
            this.speed = 1.4f;
        } else if (size == EntityGeomancyBase.GeomancyTier.LARGE) {
            this.damage = 18;
            this.speed = 1.2f;
        } else if (size == EntityGeomancyBase.GeomancyTier.HUGE) {
            this.damage = 25;
            this.speed = 1.1f;
        }
        this.damage = (int)((double)this.damage * this.getDamageMult());
    }

    protected double getDamageMult() {
        if (this.getCaster() instanceof Player) {
            return (Double)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.EARTHREND_GAUNTLET.attackMultiplier.get();
        }
        if (this.getCaster() instanceof EntitySculptor) {
            return (Double)ConfigHandler.COMMON.MOBS.SCULPTOR.combatConfig.attackMultiplier.get();
        }
        return 1.0;
    }

    public float getSpeed() {
        return this.speed;
    }

    @Override
    @NotNull
    protected AABB makeBoundingBox() {
        AABB boundingBox = super.makeBoundingBox();
        if (this.shouldExtendBoundsDown()) {
            boundingBox = boundingBox.expandTowards(0.0, -0.5, 0.0);
        }
        if (this.isTravelling()) {
            EntityGeomancyBase.GeomancyTier size = this.getTier();
            if (size == EntityGeomancyBase.GeomancyTier.MEDIUM) {
                boundingBox = boundingBox.deflate(0.15);
            } else if (size == EntityGeomancyBase.GeomancyTier.LARGE) {
                boundingBox = boundingBox.deflate(0.35);
            } else if (size == EntityGeomancyBase.GeomancyTier.HUGE) {
                boundingBox = boundingBox.deflate(0.6);
            }
        }
        return boundingBox;
    }

    protected boolean shouldExtendBoundsDown() {
        return !this.travelling;
    }

    protected void findRidingEntities() {
        if (!(this.getCaster() instanceof EntitySculptor)) {
            if (this.ridingEntities != null) {
                this.ridingEntities.clear();
            }
            List onTopOfEntities = this.level().getEntities((Entity)this, this.getBoundingBox().contract(0.0, (double)(this.getBbHeight() - 1.0f), 0.0).move(new Vec3(0.0, (double)this.getBbHeight() - 0.5, 0.0)).inflate(0.6, 0.5, 0.6));
            for (Entity entity : onTopOfEntities) {
                if (entity == null || !entity.isPickable() || entity instanceof EntityBoulderProjectile || !(entity.getY() >= this.getY() + 0.2) || !entity.isPushable()) continue;
                this.ridingEntities.add(entity);
            }
        }
    }

    @Override
    public void tick() {
        if (this.startActive() && this.tickCount == 1) {
            this.activate();
        }
        super.tick();
        if (this.level().isLoaded(this.blockPosition()) && !this.level().isClientSide() && (this.getCaster() == null || this.getCaster().isRemoved())) {
            this.explode();
        }
        this.findRidingEntities();
        if (this.travelling) {
            for (Entity entity : this.ridingEntities) {
                entity.move(MoverType.SHULKER_BOX, this.getDeltaMovement().add(0.0, 0.1, 0.0));
            }
        }
        List<Entity> entitiesHit = this.getEntitiesNearby(1.7);
        if (this.travelling && !entitiesHit.isEmpty()) {
            for (Entity entity : entitiesHit) {
                LivingEntity livingEntity;
                if (entity.isRemoved() || entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).isDeadOrDying() || this.level().isClientSide || entity == this.getCaster() || entity.noPhysics || !entity.canBeHitByProjectile() || entity instanceof ItemEntity || !this.travellingBlockedBy(entity) || this.ridingEntities != null && this.ridingEntities.contains(entity) || this.hitEntities.contains(entity)) continue;
                boolean didHurt = this.getCaster() != null ? entity.hurt(this.damageSources().mobProjectile((Entity)this, this.getCaster()), (float)this.damage) : entity.hurt(this.damageSources().generic(), (float)this.damage);
                if (didHurt) {
                    this.hitEntities.add(entity);
                }
                if (!this.isAlive() || this.getTier() == EntityGeomancyBase.GeomancyTier.HUGE) continue;
                this.explode();
            }
        }
        this.handleHitOtherBoulders();
        if (this.travelling && (!this.level().getEntities((Entity)this, this.getBoundingBox().inflate(0.1), e -> (this.ridingEntities == null || !this.ridingEntities.contains(e)) && e.canBeCollidedWith() && this.travellingBlockedBy((Entity)e)).isEmpty() || Iterables.size((Iterable)this.level().getBlockCollisions((Entity)this, this.getBoundingBox().inflate(0.1))) > 0)) {
            this.explode();
        }
        if (this.level().isClientSide() && ((Vector3f)this.getEntityData().get(SHOOT_DIRECTION)).length() > 0.0f && !this.didShootParticles) {
            Vec3 vec3 = new Vec3((Vector3f)this.getEntityData().get(SHOOT_DIRECTION)).scale(-1.0).normalize();
            ParticleRotation.OrientVector rotation = new ParticleRotation.OrientVector(vec3);
            AdvancedParticleBase.spawnAlwaysVisibleParticle(this.level(), ParticleHandler.RING2, 64.0, (float)this.getX() + (float)vec3.x, (float)this.getY() + 0.5f + (float)vec3.y, (float)this.getZ() + (float)vec3.z, 0.0, 0.0, 0.0, rotation, 3.5, 0.83f, 1.0, 0.39f, 1.0, 1.0, (int)(5.0f + 2.0f * this.getBbWidth()), true, true, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, ParticleComponent.KeyTrack.startAndEnd(0.7f, 0.0f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, ParticleComponent.KeyTrack.startAndEnd(0.0f, (1.0f + 0.5f * this.getBbWidth()) * 8.0f * this.getShootRingParticleScale()), false)});
            this.didShootParticles = true;
        }
    }

    public List<Entity> getRidingEntities() {
        return this.ridingEntities;
    }

    protected boolean startActive() {
        return true;
    }

    protected boolean travellingBlockedBy(Entity entity) {
        if (this.getCaster() instanceof EntitySculptor) {
            if (entity instanceof EntityEarthSpike) {
                return false;
            }
            return !(entity instanceof EntityBoulderBase) || ((EntityBoulderProjectile)entity).getCaster() != this.getCaster();
        }
        return true;
    }

    public boolean canCollideWith(Entity entity) {
        if (this.getCaster() instanceof EntitySculptor) {
            if (this.travelling && entity instanceof EntityEarthSpike) {
                return false;
            }
            if (entity instanceof EntityBoulderBase && ((EntityBoulderProjectile)entity).getCaster() == this.getCaster()) {
                return false;
            }
            if (entity == this.getCaster()) {
                return false;
            }
            return super.canCollideWith(entity);
        }
        return super.canCollideWith(entity);
    }

    protected void handleHitOtherBoulders() {
        List bouldersHit = this.level().getEntitiesOfClass(EntityBoulderProjectile.class, this.getBoundingBox().inflate(0.2, 0.2, 0.2).move(this.getDeltaMovement().normalize().scale(0.5)));
        if (this.travelling && !bouldersHit.isEmpty()) {
            for (EntityBoulderProjectile otherBoulder : bouldersHit) {
                if (otherBoulder.getCaster() != this.getCaster() || otherBoulder.travelling || !this.travellingBlockedBy(otherBoulder)) continue;
                otherBoulder.skipAttackInteraction(this);
                this.explode();
            }
        }
    }

    @Override
    public boolean isPickable() {
        return true;
    }

    public void shoot(Vec3 shootDirection) {
        this.setDeltaMovement(shootDirection);
        if (!this.travelling) {
            this.setDeathTime(60);
        }
        this.travelling = true;
        this.setBoundingBox(this.getType().getSpawnAABB(this.getX(), this.getY(), this.getZ()));
        if (this.boulderSize == EntityGeomancyBase.GeomancyTier.SMALL) {
            this.playSound((SoundEvent)MMSounds.EFFECT_GEOMANCY_HIT_SMALL.get(), 1.5f, 1.3f);
            this.playSound((SoundEvent)MMSounds.EFFECT_GEOMANCY_MAGIC_SMALL.get(), 1.5f, 0.9f);
        } else if (this.boulderSize == EntityGeomancyBase.GeomancyTier.MEDIUM) {
            this.playSound((SoundEvent)MMSounds.EFFECT_GEOMANCY_HIT_SMALL.get(), 1.5f, 0.9f);
            this.playSound((SoundEvent)MMSounds.EFFECT_GEOMANCY_MAGIC_SMALL.get(), 1.5f, 0.5f);
        } else if (this.boulderSize == EntityGeomancyBase.GeomancyTier.LARGE) {
            this.playSound((SoundEvent)MMSounds.EFFECT_GEOMANCY_HIT_SMALL.get(), 1.5f, 0.5f);
            this.playSound((SoundEvent)MMSounds.EFFECT_GEOMANCY_MAGIC_BIG.get(), 1.5f, 1.3f);
            EntityCameraShake.cameraShake(this.level(), this.position(), 10.0f, 0.05f, 0, 20);
        } else if (this.boulderSize == EntityGeomancyBase.GeomancyTier.HUGE) {
            this.playSound((SoundEvent)MMSounds.EFFECT_GEOMANCY_HIT_MEDIUM_1.get(), 1.5f, 1.0f);
            this.playSound((SoundEvent)MMSounds.EFFECT_GEOMANCY_MAGIC_BIG.get(), 1.5f, 0.9f);
            EntityCameraShake.cameraShake(this.level(), this.position(), 15.0f, 0.05f, 0, 20);
        }
        this.getEntityData().set(SHOOT_DIRECTION, (Object)shootDirection.toVector3f());
    }

    @Override
    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SHOOT_DIRECTION, (Object)new Vector3f(0.0f, 0.0f, 0.0f));
    }

    @Override
    public void handleEntityEvent(byte id) {
        super.handleEntityEvent(id);
    }

    protected float getShootRingParticleScale() {
        return 1.0f;
    }

    public boolean skipAttackInteraction(Entity entityIn) {
        if (this.risingTick > this.finishedRisingTick - 1 && !this.travelling) {
            if (entityIn instanceof Player) {
                Player player = (Player)entityIn;
                if (EffectGeomancy.canUse((LivingEntity)((Player)entityIn))) {
                    if (this.ridingEntities.contains(player)) {
                        Vec3 lateralLookVec = Vec3.directionFromRotation((float)0.0f, (float)player.getYRot()).normalize();
                        this.shoot(new Vec3((double)this.speed * 0.5 * lateralLookVec.x, this.getDeltaMovement().y, (double)this.speed * 0.5 * lateralLookVec.z));
                    } else {
                        this.shoot(player.getLookAngle().scale((double)this.speed * 0.5));
                    }
                    AbilityHandler.INSTANCE.sendAbilityMessage(player, AbilityHandler.HIT_BOULDER_ABILITY);
                } else if (!this.level().isClientSide() && this.getCaster() == player) {
                    this.explode();
                }
            } else if (entityIn instanceof EntityBoulderProjectile) {
                EntityBoulderProjectile boulder = (EntityBoulderProjectile)entityIn;
                if (((EntityBoulderProjectile)entityIn).travelling) {
                    Vec3 thisPos = this.position();
                    Vec3 boulderPos = boulder.position();
                    Vec3 velVec = thisPos.subtract(boulderPos).normalize();
                    this.shoot(velVec.scale((double)this.speed * 0.5));
                }
            }
        }
        return super.skipAttackInteraction(entityIn);
    }

    public boolean isTravelling() {
        return this.travelling;
    }

    public void setTravelling(boolean travel) {
        this.travelling = travel;
    }

    public void setDamage(int dam) {
        this.damage = dam;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }
}

