/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LegSolver {
    public final Leg[] legs;

    public LegSolver(Leg ... legs) {
        this.legs = legs;
    }

    public final void update(LivingEntity entity) {
        double sideTheta = (double)entity.yBodyRot / 57.29577951308232;
        double sideX = Math.cos(sideTheta);
        double sideZ = Math.sin(sideTheta);
        double forwardTheta = sideTheta + 1.5707963267948966;
        double forwardX = Math.cos(forwardTheta);
        double forwardZ = Math.sin(forwardTheta);
        for (Leg leg : this.legs) {
            leg.update(entity, sideX, sideZ, forwardX, forwardZ);
        }
    }

    public static final class Leg {
        public final float forward;
        public final float side;
        private float height;
        private float prevHeight;

        public Leg(float forward, float side) {
            this.forward = forward;
            this.side = side;
        }

        public float getHeight(float delta) {
            return this.prevHeight + (this.height - this.prevHeight) * delta;
        }

        public void update(LivingEntity entity, double sideX, double sideZ, double forwardX, double forwardZ) {
            this.prevHeight = this.height;
            this.height = this.settle(entity, entity.getX() + sideX * (double)this.side + forwardX * (double)this.forward, entity.getY(), entity.getZ() + sideZ * (double)this.side + forwardZ * (double)this.forward, this.height);
        }

        private float settle(LivingEntity entity, double x, double y, double z, float height) {
            BlockPos pos = BlockPos.containing((double)x, (double)(y + 0.001), (double)z);
            float dist = this.getDistance(entity.level(), pos);
            dist = (double)(1.0f - dist) < 0.001 ? this.getDistance(entity.level(), pos.below()) + (float)y % 1.0f : (float)((double)dist - (1.0 - y % 1.0));
            if (entity.onGround() && height <= dist) {
                return height == dist ? height : Math.min(height + 0.3f, dist);
            }
            if (height > 0.0f) {
                return Math.max(height - 0.4f, dist);
            }
            return height;
        }

        private float getDistance(Level world, BlockPos pos) {
            BlockState state = world.getBlockState(pos);
            VoxelShape shape = state.getBlockSupportShape((BlockGetter)world, pos);
            float f = 0.0f;
            if (!shape.isEmpty()) {
                AABB aabb = shape.bounds();
                f = (float)aabb.maxY;
            }
            return 1.0f - Math.min(f, 1.0f);
        }
    }
}

