/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.config;

import com.bobmowzie.mowziesmobs.datagen.MMBiomeTags;
import com.bobmowzie.mowziesmobs.datagen.StructureSetHandler;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.levelgen.structure.BuiltinStructureSets;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.common.Tags;

public final class ConfigHandler {
    private static final String LANG_PREFIX = "config.mowziesmobs.";
    public static final Common COMMON;
    public static final Client CLIENT;
    private static final ModConfigSpec.Builder COMMON_BUILDER;
    private static final ModConfigSpec.Builder CLIENT_BUILDER;
    public static ModConfigSpec COMMON_CONFIG;
    public static ModConfigSpec CLIENT_CONFIG;
    private static final Predicate<Object> STRING_PREDICATE;
    private static final Predicate<Object> RESOURCE_LOCATION_PREDICATE;
    private static final Predicate<Object> BIOME_COMBO_PREDICATE;
    private static final Predicate<Object> ITEM_NAME_PREDICATE;

    private static String inverted(Object object) {
        return "!" + ConfigHandler.string(object);
    }

    private static String string(Object object) {
        if (object instanceof TagKey) {
            TagKey tag = (TagKey)object;
            return tag.location().toString();
        }
        if (object instanceof Holder) {
            Holder holder = (Holder)object;
            return holder.getRegisteredName();
        }
        if (object instanceof ResourceKey) {
            ResourceKey key = (ResourceKey)object;
            return key.location().toString();
        }
        if (object instanceof Item) {
            Item item = (Item)object;
            return ConfigHandler.string(item.builtInRegistryHolder());
        }
        if (object instanceof Block) {
            Block block = (Block)object;
            return ConfigHandler.string(block.builtInRegistryHolder());
        }
        throw new IllegalArgumentException("Cannot handle object type [" + String.valueOf(object.getClass()) + "]");
    }

    static {
        COMMON_BUILDER = new ModConfigSpec.Builder();
        CLIENT_BUILDER = new ModConfigSpec.Builder();
        STRING_PREDICATE = s -> s instanceof String;
        RESOURCE_LOCATION_PREDICATE = STRING_PREDICATE.and(s -> ResourceLocation.tryParse((String)((String)s)) != null);
        BIOME_COMBO_PREDICATE = STRING_PREDICATE.and(s -> {
            String[] typeStrings;
            String bigString = (String)s;
            for (String string : typeStrings = bigString.replace(" ", "").split("[,!]")) {
                if (RESOURCE_LOCATION_PREDICATE.test(string)) continue;
                return false;
            }
            return true;
        });
        ITEM_NAME_PREDICATE = RESOURCE_LOCATION_PREDICATE.and(s -> BuiltInRegistries.ITEM.containsKey(ResourceLocation.tryParse((String)((String)s))));
        COMMON = new Common(COMMON_BUILDER);
        CLIENT = new Client(CLIENT_BUILDER);
        COMMON_CONFIG = COMMON_BUILDER.build();
        CLIENT_CONFIG = CLIENT_BUILDER.build();
    }

    public static class Common {
        public final ToolsAndAbilities TOOLS_AND_ABILITIES;
        public final Mobs MOBS;

        private Common(ModConfigSpec.Builder builder) {
            this.TOOLS_AND_ABILITIES = new ToolsAndAbilities(builder);
            this.MOBS = new Mobs(builder);
        }
    }

    public static class Client {
        public final ModConfigSpec.BooleanValue glowEffect;
        public final ModConfigSpec.BooleanValue umvuthanaFootprints;
        public final ModConfigSpec.BooleanValue doCameraShakes;
        public final ModConfigSpec.BooleanValue playBossMusic;
        public final ModConfigSpec.BooleanValue customBossBars;
        public final ModConfigSpec.BooleanValue customPlayerAnims;
        public final ModConfigSpec.BooleanValue hidePlayerAnimsInFirstPerson;
        public final ModConfigSpec.BooleanValue doUmvuthanaCraneHealSound;

        private Client(ModConfigSpec.Builder builder) {
            builder.push("client");
            this.glowEffect = builder.comment("Toggles the lantern glow effect, which may look bad with certain shaders.").translation("config.mowziesmobs.glow_effect").define("glow_effect", true);
            this.umvuthanaFootprints = builder.comment("Toggles the Umvuthana footprint effects, which may decrease performance.").translation("config.mowziesmobs.umvuthana_footprints").define("umvuthana_footprints", true);
            this.doCameraShakes = builder.comment("Enable camera shaking during certain mob attacks and abilities.").translation("config.mowziesmobs.do_camera_shake").define("do_camera_shake", true);
            this.playBossMusic = builder.comment("Play boss battle themes during boss encounters.").translation("config.mowziesmobs.play_boss_music").define("play_boss_music", true);
            this.customBossBars = builder.comment("Use custom boss health bar textures, if the boss has them.").translation("config.mowziesmobs.custom_boss_bar").define("custom_boss_bar", true);
            this.customPlayerAnims = builder.comment("Use custom player animations.").translation("config.mowziesmobs.custom_player_anims").define("custom_player_anims", true);
            this.hidePlayerAnimsInFirstPerson = builder.comment("Set to true to hide your own 3rd-person player animations while you are in 1st-person view mode. This is useful with mods that render the 3rd-person model in 1st-person, as some of the Mowzie's Mobs 3rd-person animations can block the camera.").translation("config.mowziesmobs.hide_player_anims_in_first_person").define("hide_player_anims_in_first_person", false);
            this.doUmvuthanaCraneHealSound = builder.comment("Play Umvuthana Crane heal sounds. Turn this off if you are experiencing crashes when Cranes appear during Umvuthi's boss battle.").translation("config.mowziesmobs.crane_heal_sounds").define("crane_heal_sounds", true);
            builder.pop();
        }
    }

    public static class ToolsAndAbilities {
        public final SunsBlessing SUNS_BLESSING;
        public final WroughtHelm WROUGHT_HELM;
        public final AxeOfAThousandMetals AXE_OF_A_THOUSAND_METALS;
        public final SolVisage SOL_VISAGE;
        public final IceCrystal ICE_CRYSTAL;
        public final UmvuthanaMask UMVUTHANA_MASK;
        public final GeomancerArmor GEOMANCER_ARMOR;
        public final Spear SPEAR;
        public final NagaFangDagger NAGA_FANG_DAGGER;
        public final Blowgun BLOW_GUN;
        public final EarthrendGauntlet EARTHREND_GAUNTLET;
        public final SculptorStaff SCULPTOR_STAFF;

        ToolsAndAbilities(ModConfigSpec.Builder builder) {
            builder.push("tools_and_abilities");
            this.SUNS_BLESSING = new SunsBlessing(builder);
            this.WROUGHT_HELM = new WroughtHelm(builder);
            this.AXE_OF_A_THOUSAND_METALS = new AxeOfAThousandMetals(builder);
            this.SOL_VISAGE = new SolVisage(builder);
            this.ICE_CRYSTAL = new IceCrystal(builder);
            this.UMVUTHANA_MASK = new UmvuthanaMask(builder);
            this.GEOMANCER_ARMOR = new GeomancerArmor(builder);
            this.SPEAR = new Spear(builder);
            this.NAGA_FANG_DAGGER = new NagaFangDagger(builder);
            this.BLOW_GUN = new Blowgun(builder);
            this.EARTHREND_GAUNTLET = new EarthrendGauntlet(builder);
            this.SCULPTOR_STAFF = new SculptorStaff(builder);
            builder.pop();
        }
    }

    public static class Mobs {
        public final Frostmaw FROSTMAW;
        public final Umvuthi UMVUTHI;
        public final FerrousWroughtnaut FERROUS_WROUGHTNAUT;
        public final Sculptor SCULPTOR;
        public final Grottol GROTTOL;
        public final Lantern LANTERN;
        public final Umvuthana UMVUTHANA;
        public final Naga NAGA;
        public final Foliaath FOLIAATH;
        public final Bluff BLUFF;

        Mobs(ModConfigSpec.Builder builder) {
            builder.push("mobs");
            this.FROSTMAW = new Frostmaw(builder);
            this.UMVUTHI = new Umvuthi(builder);
            this.FERROUS_WROUGHTNAUT = new FerrousWroughtnaut(builder);
            this.SCULPTOR = new Sculptor(builder);
            this.GROTTOL = new Grottol(builder);
            this.LANTERN = new Lantern(builder);
            this.UMVUTHANA = new Umvuthana(builder);
            this.NAGA = new Naga(builder);
            this.FOLIAATH = new Foliaath(builder);
            this.BLUFF = new Bluff(builder);
            builder.pop();
        }
    }

    public static class SculptorStaff {
        public final ModConfigSpec.DoubleValue attackMultiplier;
        public final ToolConfig toolConfig;

        SculptorStaff(ModConfigSpec.Builder builder) {
            builder.push("sculptor_staff");
            this.toolConfig = new ToolConfig(builder, 3.0f, 1.0f);
            this.attackMultiplier = builder.comment("Multiply all damage done with the Sculptor Staff by this amount.").translation("config.mowziesmobs.attack_multiplier").defineInRange("attack_multiplier", 1.0, 0.0, Double.MAX_VALUE);
            builder.pop();
        }
    }

    public static class SunsBlessing {
        public final ModConfigSpec.DoubleValue sunsBlessingAttackMultiplier;
        public final ModConfigSpec.IntValue effectDuration;
        public final ModConfigSpec.IntValue solarBeamCost;
        public final ModConfigSpec.IntValue supernovaCost;

        SunsBlessing(ModConfigSpec.Builder builder) {
            builder.push("suns_blessing");
            this.effectDuration = builder.comment("Duration in minutes of the Sun's Blessing effect.").translation("config.mowziesmobs.suns_blessing_duration").defineInRange("suns_blessing_duration", 60, 0, Integer.MAX_VALUE);
            this.sunsBlessingAttackMultiplier = builder.translation("config.mowziesmobs.suns_blessing_attack_multiplier").defineInRange("suns_blessing_attack_multiplier", 1.0, 0.0, Double.MAX_VALUE);
            this.solarBeamCost = builder.comment("Cost in minutes of using the solar beam ability.").translation("config.mowziesmobs.solar_beam_cost").defineInRange("solar_beam_cost", 5, 0, Integer.MAX_VALUE);
            builder.pop();
            this.supernovaCost = builder.comment("Cost in minutes of using the supernova ability.").translation("config.mowziesmobs.supernova_cost").defineInRange("supernova_cost", 60, 0, Integer.MAX_VALUE);
        }
    }

    public static class Blowgun {
        public final ModConfigSpec.DoubleValue attackDamage;
        public final ModConfigSpec.IntValue poisonDuration;

        Blowgun(ModConfigSpec.Builder builder) {
            builder.push("blowgun");
            this.poisonDuration = builder.comment("Duration in ticks of the poison effect (20 ticks = 1 second).").translation("config.mowziesmobs.poison_duration").defineInRange("poison_duration", 40, 0, Integer.MAX_VALUE);
            this.attackDamage = builder.comment("Multiply all damage done with the blowgun/darts by this amount.").translation("config.mowziesmobs.attack_damage").defineInRange("attack_damage", 1.0, 0.0, Double.MAX_VALUE);
            builder.pop();
        }
    }

    public static class NagaFangDagger {
        public final ToolConfig toolConfig;
        public final ModConfigSpec.IntValue poisonDuration;
        public final ModConfigSpec.DoubleValue backstabDamageMultiplier;

        NagaFangDagger(ModConfigSpec.Builder builder) {
            builder.push("naga_fang_dagger");
            this.toolConfig = new ToolConfig(builder, 3.0f, 2.0f);
            this.poisonDuration = builder.comment("Duration in ticks of the poison effect (20 ticks = 1 second).").translation("config.mowziesmobs.poison_duration").defineInRange("poison_duration", 40, 0, Integer.MAX_VALUE);
            this.backstabDamageMultiplier = builder.comment("Damage multiplier when attacking from behind").translation("config.mowziesmobs.backstab_damage_mult").defineInRange("backstab_damage_mult", 2.0, 0.0, Double.MAX_VALUE);
            builder.pop();
        }
    }

    public static class Spear {
        public final ToolConfig toolConfig;

        Spear(ModConfigSpec.Builder builder) {
            builder.push("spear");
            this.toolConfig = new ToolConfig(builder, 5.0f, 1.6f);
            builder.pop();
        }
    }

    public static class EarthrendGauntlet {
        public final ModConfigSpec.DoubleValue attackMultiplier;
        public final ModConfigSpec.BooleanValue breakable;
        public final ModConfigSpec.IntValue durability;
        public int durabilityValue;
        public final ToolConfig toolConfig;
        public final ModConfigSpec.BooleanValue enableTunneling;

        EarthrendGauntlet(ModConfigSpec.Builder builder) {
            builder.push("earthrend_gauntlet");
            this.attackMultiplier = builder.comment("Multiply all damage done with the Earthrend Gauntlet by this amount.").translation("config.mowziesmobs.attack_multiplier").defineInRange("attack_multiplier", 1.0, 0.0, Double.MAX_VALUE);
            this.breakable = builder.comment(new String[]{"Set to true for the Earthrend Gauntlet to have limited durability.", "Prevents regeneration in inventory."}).translation("config.mowziesmobs.breakable").define("breakable", false);
            this.durability = builder.comment("Earthrend Gauntlet durability").translation("config.mowziesmobs.durability").defineInRange("durability", 400, 1, Integer.MAX_VALUE);
            this.enableTunneling = builder.comment("Set to false to disable the Earthrend Gauntlet's tunneling ability.").translation("config.mowziesmobs.enable_tunneling").define("enable_tunneling", true);
            this.toolConfig = new ToolConfig(builder, 6.0f, 1.2f);
            builder.pop();
        }
    }

    public static class IceCrystal {
        public final ModConfigSpec.DoubleValue attackMultiplier;
        public final ModConfigSpec.BooleanValue breakable;
        public final ModConfigSpec.IntValue durability;
        public int durabilityValue;
        public final ModConfigSpec.IntValue freezeDuration;

        IceCrystal(ModConfigSpec.Builder builder) {
            builder.push("ice_crystal");
            this.attackMultiplier = builder.comment("Multiply all damage done with the ice crystal by this amount.").translation("config.mowziesmobs.attack_multiplier").defineInRange("attack_multiplier", 1.0, 0.0, Double.MAX_VALUE);
            this.breakable = builder.comment(new String[]{"Set to true for the ice crystal to have limited durability.", "Prevents regeneration in inventory."}).translation("config.mowziesmobs.breakable").define("breakable", false);
            this.durability = builder.comment("Ice crystal durability").translation("config.mowziesmobs.durability").defineInRange("durability", 600, 1, Integer.MAX_VALUE);
            this.freezeDuration = builder.comment("Freeze duration in ticks (applies to frostmaw too!)").translation("config.mowziesmobs.freeze_duration").defineInRange("freeze_duration", 50, 1, Integer.MAX_VALUE);
            builder.pop();
        }
    }

    public static class GeomancerArmor {
        public final ArmorConfig armorConfig;

        GeomancerArmor(ModConfigSpec.Builder builder) {
            builder.push("geomancerArmor");
            this.armorConfig = new ArmorConfig(builder);
            builder.pop();
        }
    }

    public static class UmvuthanaMask {
        public final ArmorConfig armorConfig;

        UmvuthanaMask(ModConfigSpec.Builder builder) {
            builder.push("umvuthana_mask");
            this.armorConfig = new ArmorConfig(builder);
            builder.pop();
        }
    }

    public static class SolVisage {
        public final ArmorConfig armorConfig;
        public final ModConfigSpec.BooleanValue breakable;
        public final ModConfigSpec.IntValue maxFollowers;

        SolVisage(ModConfigSpec.Builder builder) {
            builder.push("sol_visage");
            this.armorConfig = new ArmorConfig(builder);
            this.breakable = builder.comment("Set to true for the Sol Visage to have limited durability.").translation("config.mowziesmobs.breakable").define("breakable", false);
            this.maxFollowers = builder.comment("Maximum number of Umvuthana followers a player can summon at once using the Sol Visage").translation("config.mowziesmobs.max_followers").defineInRange("max_followers", 10, 0, 300);
            builder.pop();
        }
    }

    public static class AxeOfAThousandMetals {
        public final ToolConfig toolConfig;
        public final ModConfigSpec.BooleanValue breakable;

        AxeOfAThousandMetals(ModConfigSpec.Builder builder) {
            builder.push("axe_of_a_thousand_metals");
            this.toolConfig = new ToolConfig(builder, 9.0f, 0.9f);
            this.breakable = builder.comment("Set to true for the Axe of a Thousand Metals to have limited durability.").translation("config.mowziesmobs.breakable").define("breakable", false);
            builder.pop();
        }
    }

    public static class WroughtHelm {
        public final ArmorConfig armorConfig;
        public final ModConfigSpec.BooleanValue breakable;

        WroughtHelm(ModConfigSpec.Builder builder) {
            builder.push("wrought_helm");
            this.armorConfig = new ArmorConfig(builder);
            this.breakable = builder.comment("Set to true for the Wrought Helm to have limited durability.").translation("config.mowziesmobs.breakable").define("breakable", false);
            builder.pop();
        }
    }

    public static class Bluff {
        public final SpawnConfig spawnConfig;
        public final CombatConfig combatConfig;

        Bluff(ModConfigSpec.Builder builder) {
            builder.push("bluff");
            this.spawnConfig = new SpawnConfig(builder, 10, 2, 3, 1.0, new BiomeConfig(builder, Collections.emptyList(), Collections.emptyList(), Collections.emptyList()), Collections.emptyList(), Collections.emptyList(), -65, -65, true, false, true, Collections.emptyList());
            this.combatConfig = new CombatConfig(builder, 1.0f, 1.0f);
            builder.pop();
        }
    }

    public static class Sculptor {
        public final GenerationConfig generationConfig;
        public final CombatConfig combatConfig;
        public final ModConfigSpec.IntValue testHeight;
        public final ModConfigSpec.IntValue testTimeLimit;
        public final ModConfigSpec.BooleanValue healsOutOfBattle;
        public final ModConfigSpec.BooleanValue hasBossBar;
        public final ModConfigSpec.ConfigValue<? extends String> whichItem;
        public final ModConfigSpec.IntValue howMany;
        public final ModConfigSpec.BooleanValue disappearAfterReward;

        Sculptor(ModConfigSpec.Builder builder) {
            builder.push("sculptor");
            this.generationConfig = new GenerationConfig(builder, 25, 8, new BiomeConfig(builder, Collections.singletonList(ConfigHandler.string(Tags.Biomes.IS_MOUNTAIN_PEAK)), Collections.emptyList(), Collections.emptyList()), 120.0f, 200.0f, Collections.emptyList());
            this.combatConfig = new CombatConfig(builder, 1.0f, 1.0f);
            this.testHeight = builder.comment("How tall (in blocks) the Sculptor's test will be").translation("config.mowziesmobs.test_height").defineInRange("test_height", 60, 1, 500);
            this.testTimeLimit = builder.comment("The time limit (in seconds) for completing the Sculptor's test").translation("config.mowziesmobs.test_time_limit").defineInRange("test_time_limit", 400, 1, 36000);
            this.healsOutOfBattle = builder.comment("Disable/enable the Sculptor healing while not in combat").translation("config.mowziesmobs.heals_out_of_battle").define("heals_out_of_battle", true);
            this.hasBossBar = builder.comment("Disable/enable the Sculptor's boss health bar").translation("config.mowziesmobs.has_boss_bar").define("has_boss_bar", true);
            this.whichItem = builder.comment("Which item the Sculptor desires in exchange for a chance to try his challenge").translation("config.mowziesmobs.trade_which_item").define("trade_which_item", (Object)ConfigHandler.string(ItemHandler.BLUFF_ROD), ITEM_NAME_PREDICATE);
            this.howMany = builder.comment("How many of the item the Sculptor desires in exchange for a chance to try his challenge").translation("config.mowziesmobs.trade_how_many").defineInRange("trade_how_many", 1, 0, 64);
            this.disappearAfterReward = builder.comment("Set to true for the Sculptor to disappear after a player beats the test and claims the reward.").translation("config.mowziesmobs.disappear_after_reward").define("disappear_after_reward", true);
            builder.pop();
        }
    }

    public static class Frostmaw {
        public final GenerationConfig generationConfig;
        public final CombatConfig combatConfig;
        public final ModConfigSpec.BooleanValue stealableIceCrystal;
        public final ModConfigSpec.BooleanValue hasBossBar;
        public final ModConfigSpec.BooleanValue healsOutOfBattle;
        public final ModConfigSpec.BooleanValue resetHealthWhenRespawn;

        Frostmaw(ModConfigSpec.Builder builder) {
            builder.push("frostmaw");
            this.generationConfig = new GenerationConfig(builder, 25, 8, new BiomeConfig(builder, Collections.singletonList(ConfigHandler.string(Tags.Biomes.IS_SNOWY) + "," + ConfigHandler.inverted(Tags.Biomes.IS_OCEAN) + "," + ConfigHandler.inverted(Tags.Biomes.IS_RIVER) + "," + ConfigHandler.inverted(Tags.Biomes.IS_BEACH) + "," + ConfigHandler.inverted(Tags.Biomes.IS_FOREST) + "," + ConfigHandler.inverted(Tags.Biomes.IS_TAIGA)), Collections.emptyList(), Collections.emptyList()), 50.0f, 100.0f, Arrays.asList(ConfigHandler.string(BuiltinStructureSets.VILLAGES), ConfigHandler.string(BuiltinStructureSets.PILLAGER_OUTPOSTS)));
            this.combatConfig = new CombatConfig(builder, 1.0f, 1.0f);
            this.hasBossBar = builder.comment("Disable/enable Frostmaw's boss health bar").translation("config.mowziesmobs.has_boss_bar").define("has_boss_bar", true);
            this.healsOutOfBattle = builder.comment("Disable/enable frostmaws healing while asleep").translation("config.mowziesmobs.heals_out_of_battle").define("heals_out_of_battle", true);
            this.stealableIceCrystal = builder.comment("Allow players to steal frostmaws' ice crystals (only using specific means!)").translation("config.mowziesmobs.stealable_ice_crystal").define("stealable_ice_crystal", true);
            this.resetHealthWhenRespawn = builder.comment("Disable/enable frostmaws resetting health when a player respawns nearby. (Prevents respawn cheese!)").translation("config.mowziesmobs.reset_health_when_respawn").define("reset_health_when_respawn", true);
            builder.pop();
        }
    }

    public static class Umvuthi {
        public final GenerationConfig generationConfig;
        public final CombatConfig combatConfig;
        public final ModConfigSpec.BooleanValue hasBossBar;
        public final ModConfigSpec.BooleanValue healsOutOfBattle;
        public final ModConfigSpec.ConfigValue<? extends String> whichItem;
        public final ModConfigSpec.IntValue howMany;
        public final ModConfigSpec.BooleanValue resetHealthWhenRespawn;
        public final ModConfigSpec.IntValue spawnHealersThreshold;

        Umvuthi(ModConfigSpec.Builder builder) {
            builder.push("umvuthi");
            builder.comment("Generation controls for Umvuthana Groves");
            this.generationConfig = new GenerationConfig(builder, 25, 8, new BiomeConfig(builder, Collections.singletonList(ConfigHandler.string(Tags.Biomes.IS_SAVANNA)), Collections.emptyList(), Collections.emptyList()), 50.0f, 100.0f, Arrays.asList(ConfigHandler.string(BuiltinStructureSets.VILLAGES), ConfigHandler.string(BuiltinStructureSets.PILLAGER_OUTPOSTS)));
            this.combatConfig = new CombatConfig(builder, 1.0f, 1.0f);
            this.hasBossBar = builder.comment("Disable/enable Umvuthi's boss health bar").translation("config.mowziesmobs.has_boss_bar").define("has_boss_bar", true);
            this.healsOutOfBattle = builder.comment("Disable/enable Umvuthi healing while not in combat").translation("config.mowziesmobs.heals_out_of_battle").define("heals_out_of_battle", true);
            this.whichItem = builder.comment("Which item Umvuthi desires in exchange for the Sun's Blessing").translation("config.mowziesmobs.trade_which_item").define("trade_which_item", (Object)ConfigHandler.string(Items.GOLD_BLOCK), ITEM_NAME_PREDICATE);
            this.howMany = builder.comment("How many of the item Umvuthi desires in exchange for the Sun's Blessing").translation("config.mowziesmobs.trade_how_many").defineInRange("trade_how_many", 7, 0, 64);
            this.resetHealthWhenRespawn = builder.comment("Disable/enable Umvuthi resetting health when a player respawns nearby. (Prevents respawn cheese!)").translation("config.mowziesmobs.reset_health_when_respawn").define("reset_health_when_respawn", true);
            this.spawnHealersThreshold = builder.comment("Umvuthi will summon healers whenever he loses this much total health.").translation("config.mowziesmobs.spawn_healers_threshold").defineInRange("spawn_healers_threshold", 45, 0, Integer.MAX_VALUE);
            builder.pop();
        }
    }

    public static class FerrousWroughtnaut {
        public final GenerationConfig generationConfig;
        public final CombatConfig combatConfig;
        public final ModConfigSpec.BooleanValue hasBossBar;
        public final ModConfigSpec.BooleanValue healsOutOfBattle;
        public final ModConfigSpec.BooleanValue resetHealthWhenRespawn;

        FerrousWroughtnaut(ModConfigSpec.Builder builder) {
            builder.push("ferrous_wroughtnaut");
            this.generationConfig = new GenerationConfig(builder, 15, 5, new BiomeConfig(builder, Collections.singletonList(ConfigHandler.inverted(Tags.Biomes.IS_OCEAN)), Collections.emptyList(), Collections.emptyList()), 20.0f, 50.0f, Collections.emptyList());
            this.combatConfig = new CombatConfig(builder, 1.0f, 1.0f);
            this.hasBossBar = builder.comment("Disable/enable Ferrous Wroughtnaut's boss health bar").translation("config.mowziesmobs.has_boss_bar").define("has_boss_bar", true);
            this.healsOutOfBattle = builder.comment("Disable/enable Ferrous Wroughtnaut healing while not active").translation("config.mowziesmobs.heals_out_of_battle").define("heals_out_of_battle", true);
            this.resetHealthWhenRespawn = builder.comment("Disable/enable Ferrous Wroughtnaut resetting health when a player respawns nearby. (Prevents respawn cheese!)").translation("config.mowziesmobs.reset_health_when_respawn").define("reset_health_when_respawn", true);
            builder.pop();
        }
    }

    public static class Grottol {
        public final SpawnConfig spawnConfig;
        public final CombatConfig combatConfig;

        Grottol(ModConfigSpec.Builder builder) {
            builder.push("grottol");
            this.spawnConfig = new SpawnConfig(builder, 2, 1, 1, 1.0, new BiomeConfig(builder, Collections.singletonList(ConfigHandler.inverted(Tags.Biomes.IS_MUSHROOM)), Collections.emptyList(), Collections.emptyList()), Collections.emptyList(), Collections.singletonList(ConfigHandler.string(BlockTags.BASE_STONE_OVERWORLD)), 16, -65, true, false, true, Collections.emptyList());
            this.combatConfig = new CombatConfig(builder, 1.0f, 1.0f);
            builder.pop();
        }
    }

    public static class Lantern {
        public final SpawnConfig spawnConfig;
        public final CombatConfig combatConfig;

        Lantern(ModConfigSpec.Builder builder) {
            builder.push("lantern");
            this.spawnConfig = new SpawnConfig(builder, 5, 2, 4, 1.0, new BiomeConfig(builder, Collections.singletonList(ConfigHandler.string(Tags.Biomes.IS_FOREST) + "," + ConfigHandler.string(MMBiomeTags.IS_MAGICAL) + "," + ConfigHandler.inverted(Tags.Biomes.IS_SNOWY)), Collections.emptyList(), Collections.emptyList()), Collections.emptyList(), Arrays.asList(ConfigHandler.string(BlockTags.ANIMALS_SPAWNABLE_ON), ConfigHandler.string(BlockTags.LEAVES), ConfigHandler.string(BlockTags.LOGS)), -65, 60, true, false, false, Collections.emptyList());
            this.combatConfig = new CombatConfig(builder, 1.0f, 1.0f);
            builder.pop();
        }
    }

    public static class Naga {
        public final SpawnConfig spawnConfig;
        public final CombatConfig combatConfig;

        Naga(ModConfigSpec.Builder builder) {
            builder.push("naga");
            this.spawnConfig = new SpawnConfig(builder, 20, 1, 2, 1.0, new BiomeConfig(builder, Arrays.asList(ConfigHandler.string(Tags.Biomes.IS_BEACH) + "," + ConfigHandler.string(Tags.Biomes.IS_MOUNTAIN), ConfigHandler.string(Tags.Biomes.IS_BEACH) + "," + ConfigHandler.string(BiomeTags.IS_HILL)), Collections.singletonList(ConfigHandler.string(Biomes.STONY_SHORE)), Collections.emptyList()), Collections.emptyList(), List.of(ConfigHandler.string(BlockTags.ANIMALS_SPAWNABLE_ON), ConfigHandler.string(BlockTags.BASE_STONE_OVERWORLD)), -65, 68, true, true, false, Arrays.asList(ConfigHandler.string(BuiltinStructureSets.VILLAGES), ConfigHandler.string(BuiltinStructureSets.PILLAGER_OUTPOSTS)));
            this.combatConfig = new CombatConfig(builder, 1.0f, 1.0f);
            builder.pop();
        }
    }

    public static class Umvuthana {
        public final SpawnConfig spawnConfig;
        public final CombatConfig combatConfig;

        Umvuthana(ModConfigSpec.Builder builder) {
            builder.push("umvuthana");
            builder.comment(new String[]{"Controls spawning for Umvuthana hunting groups", "Group size controls how many raptors spawn, not followers", "See Umvuthi config for grove structure controls"});
            this.spawnConfig = new SpawnConfig(builder, 5, 1, 1, 1.0, new BiomeConfig(builder, Collections.singletonList(ConfigHandler.string(Tags.Biomes.IS_SAVANNA)), Collections.emptyList(), Collections.emptyList()), Collections.emptyList(), Arrays.asList(ConfigHandler.string(BlockTags.ANIMALS_SPAWNABLE_ON), ConfigHandler.string(BlockTags.SAND)), -65, 60, false, false, false, Arrays.asList(ConfigHandler.string(BuiltinStructureSets.VILLAGES), ConfigHandler.string(BuiltinStructureSets.PILLAGER_OUTPOSTS), ConfigHandler.string(StructureSetHandler.UMVUTHANA_GROVES)));
            this.combatConfig = new CombatConfig(builder, 1.0f, 1.0f);
            builder.pop();
        }
    }

    public static class Foliaath {
        public final SpawnConfig spawnConfig;
        public final CombatConfig combatConfig;

        Foliaath(ModConfigSpec.Builder builder) {
            builder.push("foliaath");
            this.spawnConfig = new SpawnConfig(builder, 70, 1, 4, 1.0, new BiomeConfig(builder, Collections.singletonList(ConfigHandler.string(Tags.Biomes.IS_JUNGLE)), Collections.emptyList(), Collections.emptyList()), Collections.emptyList(), Arrays.asList(ConfigHandler.string(BlockTags.ANIMALS_SPAWNABLE_ON), ConfigHandler.string(BlockTags.LEAVES), ConfigHandler.string(BlockTags.LOGS)), -65, 60, true, false, false, Arrays.asList(ConfigHandler.string(BuiltinStructureSets.VILLAGES), ConfigHandler.string(BuiltinStructureSets.PILLAGER_OUTPOSTS)));
            this.combatConfig = new CombatConfig(builder, 1.0f, 1.0f);
            builder.pop();
        }
    }

    public static class ArmorConfig {
        public final ModConfigSpec.DoubleValue damageReductionMultiplier;
        public final ModConfigSpec.DoubleValue toughnessMultiplier;
        public float damageReductionMultiplierValue = 1.0f;
        public float toughnessMultiplierValue = 1.0f;

        ArmorConfig(ModConfigSpec.Builder builder) {
            builder.push("armor_config");
            this.damageReductionMultiplier = builder.comment("Multiply armor damage reduction by this amount. See official Minecraft Wiki for an explanation of how armor damage reduction works.").translation("config.mowziesmobs.damage_reduction_multiplier").defineInRange("damage_reduction_multiplier", 1.0, 0.0, Double.MAX_VALUE);
            this.toughnessMultiplier = builder.comment("Multiply armor toughness by this amount. See official Minecraft Wiki for an explanation of how armor toughness works.").translation("config.mowziesmobs.toughness_multiplier").defineInRange("toughness_multiplier", 1.0, 0.0, Double.MAX_VALUE);
            builder.pop();
        }
    }

    public static class ToolConfig {
        public final ModConfigSpec.DoubleValue attackDamage;
        public float attackDamageValue = 9.0f;
        public float attackSpeedValue = 0.9f;
        public final ModConfigSpec.DoubleValue attackSpeed;

        ToolConfig(ModConfigSpec.Builder builder, float attackDamage, float attackSpeed) {
            builder.push("tool_config");
            this.attackDamage = builder.comment("Tool attack damage").translation("config.mowziesmobs.attack_damage").defineInRange("attack_damage", (double)attackDamage, 0.0, Double.MAX_VALUE);
            this.attackSpeed = builder.comment("Tool attack speed").translation("config.mowziesmobs.attack_speed").defineInRange("attack_speed", (double)attackSpeed, 0.0, Double.MAX_VALUE);
            builder.pop();
        }
    }

    public static class CombatConfig {
        public final ModConfigSpec.DoubleValue healthMultiplier;
        public final ModConfigSpec.DoubleValue attackMultiplier;

        CombatConfig(ModConfigSpec.Builder builder, float healthMultiplier, float attackMultiplier) {
            builder.push("combat_config");
            this.healthMultiplier = builder.comment("Scale mob health by this value").translation("config.mowziesmobs.health_multiplier").defineInRange("health_multiplier", (double)healthMultiplier, 0.0, Double.MAX_VALUE);
            this.attackMultiplier = builder.comment("Scale mob attack damage by this value").translation("config.mowziesmobs.attack_multiplier").defineInRange("attack_multiplier", (double)attackMultiplier, 0.0, Double.MAX_VALUE);
            builder.pop();
        }
    }

    public static class GenerationConfig {
        public final ModConfigSpec.IntValue generationDistance;
        public final ModConfigSpec.IntValue generationSeparation;
        public final BiomeConfig biomeConfig;
        public final ModConfigSpec.DoubleValue heightMin;
        public final ModConfigSpec.DoubleValue heightMax;
        public final ModConfigSpec.ConfigValue<List<? extends String>> avoidStructures;

        GenerationConfig(ModConfigSpec.Builder builder, int generationDistance, int generationSeparation, BiomeConfig biomeConfig, float heightMin, float heightMax, List<String> avoidStructures) {
            builder.comment("Controls for spawning structure/mob with world generation");
            builder.push("generation_config");
            this.generationDistance = builder.comment(new String[]{"Smaller number causes more generation, -1 to disable generation", "Maximum number of chunks between placements of this mob/structure.", "NO LONGER USED! USE DATAPACK INSTEAD"}).translation("config.mowziesmobs.generation_distance").defineInRange("generation_distance", generationDistance, -1, Integer.MAX_VALUE);
            this.generationSeparation = builder.comment(new String[]{"Smaller number causes more generation, -1 to disable generation", "Minimum number of chunks between placements of this mob/structure.", "NO LONGER USED! USE DATAPACK INSTEAD"}).translation("config.mowziesmobs.generation_separation").defineInRange("generation_separation", generationSeparation, -1, Integer.MAX_VALUE);
            this.biomeConfig = biomeConfig;
            this.heightMax = builder.comment("Maximum height for generation placement. -65 to ignore").translation("config.mowziesmobs.height_max").defineInRange("height_max", (double)heightMax, -65.0, 256.0);
            this.heightMin = builder.comment("Minimum height for generation placement. -65 to ignore").translation("config.mowziesmobs.height_min").defineInRange("height_min", (double)heightMin, -65.0, 256.0);
            this.avoidStructures = builder.comment(new String[]{"Names of structures this mob/structure will avoid when generating.", "NO LONGER USED! USE DATAPACK INSTEAD"}).translation("config.mowziesmobs.avoid_structures").defineList("avoid_structures", avoidStructures, STRING_PREDICATE);
            builder.pop();
        }
    }

    public static class SpawnConfig {
        public final ModConfigSpec.IntValue spawnRate;
        public final ModConfigSpec.IntValue minGroupSize;
        public final ModConfigSpec.IntValue maxGroupSize;
        public final ModConfigSpec.DoubleValue extraRarity;
        public final BiomeConfig biomeConfig;
        public final ModConfigSpec.ConfigValue<List<? extends String>> dimensions;
        public final ModConfigSpec.IntValue heightMin;
        public final ModConfigSpec.IntValue heightMax;
        public final ModConfigSpec.BooleanValue needsDarkness;
        public final ModConfigSpec.BooleanValue needsSeeSky;
        public final ModConfigSpec.BooleanValue needsCantSeeSky;
        public final ModConfigSpec.ConfigValue<List<? extends String>> allowedBlocks;
        public final ModConfigSpec.ConfigValue<List<? extends String>> allowedBlockTags;
        public final ModConfigSpec.ConfigValue<List<? extends String>> avoidStructures;

        SpawnConfig(ModConfigSpec.Builder builder, int spawnRate, int minGroupSize, int maxGroupSize, double extraRarity, BiomeConfig biomeConfig, List<? extends String> allowedBlocks, List<? extends String> allowedBlockTags, int heightMax, int heightMin, boolean needsDarkness, boolean needsSeeSky, boolean needsCantSeeSky, List<String> avoidStructures) {
            builder.comment("Controls for vanilla-style mob spawning");
            builder.push("spawn_config");
            this.spawnRate = builder.comment("Smaller number causes less spawning, 0 to disable spawning").translation("config.mowziesmobs.spawn_rate").defineInRange("spawn_rate", spawnRate, 0, Integer.MAX_VALUE);
            this.minGroupSize = builder.comment("Minimum number of mobs that appear in a spawn group").translation("config.mowziesmobs.min_group_size").defineInRange("min_group_size", minGroupSize, 1, Integer.MAX_VALUE);
            this.maxGroupSize = builder.comment("Maximum number of mobs that appear in a spawn group").translation("config.mowziesmobs.max_group_size").defineInRange("max_group_size", maxGroupSize, 1, Integer.MAX_VALUE);
            this.extraRarity = builder.comment("Probability of a spawn attempt succeeding. 1 for normal spawning, 0 will prevent spawning. Used to make mobs extra rare.").translation("config.mowziesmobs.extra_rarity").defineInRange("extra_rarity", extraRarity, 0.0, 1.0);
            this.biomeConfig = biomeConfig;
            this.dimensions = builder.comment("Names of dimensions this mob can spawn in").translation("config.mowziesmobs.dimensions").defineList("dimensions", Collections.singletonList(ConfigHandler.string(BuiltinDimensionTypes.OVERWORLD)), STRING_PREDICATE);
            this.allowedBlocks = builder.comment("Names of blocks this mob is allowed to spawn on. Leave blank to ignore block names.").translation("config.mowziesmobs.allowed_blocks").defineList("allowed_blocks", allowedBlocks, STRING_PREDICATE);
            this.allowedBlockTags = builder.comment("Tags of blocks this mob is allowed to spawn on. Leave blank to ignore block tags.").translation("config.mowziesmobs.allowed_block_tags").defineList("allowed_block_tags", allowedBlockTags, STRING_PREDICATE);
            this.heightMax = builder.comment("Maximum height for this spawn. -65 to ignore.").translation("config.mowziesmobs.height_max").defineInRange("height_max", heightMax, -65, 256);
            this.heightMin = builder.comment("Minimum height for this spawn. -65 to ignore.").translation("config.mowziesmobs.height_min").defineInRange("height_min", heightMin, -65, 256);
            this.needsDarkness = builder.comment("Set to true to only allow this mob to spawn in the dark, like zombies and skeletons.").translation("config.mowziesmobs.needs_darkness").define("needs_darkness", needsDarkness);
            this.needsSeeSky = builder.comment("Set to true to only spawn mob if it can see the sky.").translation("config.mowziesmobs.min_group_size").define("needs_see_sky", needsSeeSky);
            this.needsCantSeeSky = builder.comment("Set to true to only spawn mob if it can't see the sky.").translation("config.mowziesmobs.min_group_size").define("needs_cant_see_sky", needsCantSeeSky);
            this.avoidStructures = builder.comment("Names of structures this mob will avoid spawning near.").translation("config.mowziesmobs.avoid_structures").defineList("avoid_structures", avoidStructures, STRING_PREDICATE);
            builder.pop();
        }
    }

    public static class BiomeConfig {
        public final ModConfigSpec.ConfigValue<List<? extends String>> biomeTags;
        public final ModConfigSpec.ConfigValue<List<? extends String>> biomeWhitelist;
        public final ModConfigSpec.ConfigValue<List<? extends String>> biomeBlacklist;

        BiomeConfig(ModConfigSpec.Builder builder, List<? extends String> biomeTags, List<? extends String> biomeWhitelist, List<? extends String> biomeBlacklist) {
            builder.push("biome_config");
            builder.comment("Mowzie's Mobs bosses cannot generate in modded or non-overworld biomes unless the biome is added to the 'has_structure/has_mowzie_structure' tag via a datapack!");
            this.biomeTags = builder.comment(new String[]{"Each entry is a combination of allowed biome tags or biome names.", "Separate types with commas to require biomes to have all tags in an entry", "Put a '!' before a biome tag to mean NOT that tag", "A blank entry means all biomes. No entries means no biomes.", "For example, 'minecraft:is_forest,c:is_spooky,!c:is_snowy' would mean all biomes that are spooky forests but not snowy forests", "'!minecraft:is_mountain' would mean all non-mountain biomes"}).translation("config.mowziesmobs.biome_tags").defineList("biome_tags", biomeTags, BIOME_COMBO_PREDICATE);
            this.biomeWhitelist = builder.comment("Allow spawns in these biomes regardless of the biome tag settings").translation("config.mowziesmobs.biome_whitelist").defineList("biome_whitelist", biomeWhitelist, BIOME_COMBO_PREDICATE);
            this.biomeBlacklist = builder.comment("Prevent spawns in these biomes regardless of the biome tag settings").translation("config.mowziesmobs.biome_blacklist").defineList("biome_blacklist", biomeBlacklist, BIOME_COMBO_PREDICATE);
            builder.pop();
        }
    }
}

