/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.ai.animation;

import com.bobmowzie.mowziesmobs.server.ai.animation.SimpleAnimationAI;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityCameraShake;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityFallingBlock;
import com.bobmowzie.mowziesmobs.server.entity.wroughtnaut.EntityWroughtnaut;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.ilexiconn.llibrary.server.animation.Animation;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class AnimationFWNStompAttackAI
extends SimpleAnimationAI<EntityWroughtnaut> {
    public AnimationFWNStompAttackAI(EntityWroughtnaut entity, Animation animation) {
        super(entity, animation, true);
    }

    public void tick() {
        ((EntityWroughtnaut)this.entity).setDeltaMovement(0.0, ((EntityWroughtnaut)this.entity).getDeltaMovement().y, 0.0);
        double perpFacing = (double)((EntityWroughtnaut)this.entity).yBodyRot * (Math.PI / 180);
        double facingAngle = perpFacing + 1.5707963267948966;
        int hitY = Mth.floor((double)(((EntityWroughtnaut)this.entity).getBoundingBox().minY - 0.5));
        int tick = ((EntityWroughtnaut)this.entity).getAnimationTick();
        int maxDistance = 6;
        ServerLevel world = (ServerLevel)((EntityWroughtnaut)this.entity).level();
        if (tick == 6) {
            ((EntityWroughtnaut)this.entity).playSound((SoundEvent)MMSounds.ENTITY_WROUGHT_SHOUT_2.get(), 1.0f, 1.0f);
        } else if (tick > 9 && tick < 17) {
            if (tick == 10) {
                ((EntityWroughtnaut)this.entity).playSound((SoundEvent)MMSounds.ENTITY_WROUGHT_STEP.get(), 1.2f, 0.5f + ((EntityWroughtnaut)this.entity).getRandom().nextFloat() * 0.1f);
            } else if (tick == 12) {
                ((EntityWroughtnaut)this.entity).playSound((SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), 2.0f, 1.0f + ((EntityWroughtnaut)this.entity).getRandom().nextFloat() * 0.1f);
                EntityCameraShake.cameraShake(((EntityWroughtnaut)this.entity).level(), ((EntityWroughtnaut)this.entity).position(), 25.0f, 0.1f, 0, 20);
            }
            if (tick % 2 == 0) {
                int distance = tick / 2 - 2;
                double spread = Math.PI * 2;
                int arcLen = Mth.ceil((double)((double)distance * spread));
                double minY = ((EntityWroughtnaut)this.entity).getBoundingBox().minY;
                double maxY = ((EntityWroughtnaut)this.entity).getBoundingBox().maxY;
                for (int i = 0; i < arcLen; ++i) {
                    double theta = ((double)i / ((double)arcLen - 1.0) - 0.5) * spread + facingAngle;
                    double vx = Math.cos(theta);
                    double vz = Math.sin(theta);
                    double px = ((EntityWroughtnaut)this.entity).getX() + vx * (double)distance;
                    double pz = ((EntityWroughtnaut)this.entity).getZ() + vz * (double)distance;
                    float factor = 1.0f - (float)distance / 6.0f;
                    AABB selection = new AABB(px - 1.5, minY, pz - 1.5, px + 1.5, maxY, pz + 1.5);
                    List hit = world.getEntitiesOfClass(Entity.class, selection);
                    for (Entity entity : hit) {
                        if (!entity.onGround() || entity == this.entity || entity instanceof EntityFallingBlock) continue;
                        float applyKnockbackResistance = 0.0f;
                        if (entity instanceof LivingEntity) {
                            entity.hurt(entity.damageSources().mobAttack((LivingEntity)this.entity), (factor * 5.0f + 1.0f) * ((Double)ConfigHandler.COMMON.MOBS.FERROUS_WROUGHTNAUT.combatConfig.attackMultiplier.get()).floatValue());
                            applyKnockbackResistance = (float)((LivingEntity)entity).getAttribute(Attributes.KNOCKBACK_RESISTANCE).getValue();
                        }
                        double magnitude = world.random.nextDouble() * 0.15 + 0.1;
                        float x = 0.0f;
                        float y = 0.0f;
                        float z = 0.0f;
                        x = (float)((double)x + vx * (double)factor * magnitude * (double)(1.0f - applyKnockbackResistance));
                        y = (float)((double)y + (0.1 * (double)(1.0f - applyKnockbackResistance) + (double)factor * 0.15 * (double)(1.0f - applyKnockbackResistance)));
                        z = (float)((double)z + vz * (double)factor * magnitude * (double)(1.0f - applyKnockbackResistance));
                        entity.setDeltaMovement(entity.getDeltaMovement().add((double)x, (double)y, (double)z));
                        if (!(entity instanceof ServerPlayer)) continue;
                        ((ServerPlayer)entity).connection.send((Packet)new ClientboundSetEntityMotionPacket(entity));
                    }
                    if (!world.random.nextBoolean()) continue;
                    int hitX = Mth.floor((double)px);
                    int hitZ = Mth.floor((double)pz);
                    BlockPos pos = new BlockPos(hitX, hitY, hitZ);
                    BlockPos abovePos = new BlockPos((Vec3i)pos).above();
                    BlockState block = world.getBlockState(pos);
                    BlockState blockAbove = world.getBlockState(abovePos);
                    if (block.isAir() || !block.isRedstoneConductor((BlockGetter)world, pos) || block.hasBlockEntity() || blockAbove.blocksMotion()) continue;
                    EntityFallingBlock fallingBlock = new EntityFallingBlock((EntityType)EntityHandler.FALLING_BLOCK.get(), (Level)world, block, (float)(0.4 + (double)factor * 0.2));
                    fallingBlock.setPos((double)hitX + 0.5, hitY + 1, (double)hitZ + 0.5);
                    world.addFreshEntity((Entity)fallingBlock);
                }
            }
        }
    }
}

