/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.render.entity;

import com.bobmowzie.mowziesmobs.client.model.tools.MathUtils;
import com.bobmowzie.mowziesmobs.client.render.MMRenderType;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntitySunstrike;
import com.ilexiconn.llibrary.client.util.ClientUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class RenderSunstrike
extends EntityRenderer<EntitySunstrike> {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"mowziesmobs", (String)"textures/effects/sunstrike.png");
    private static final Random RANDOMIZER = new Random(0L);
    private static final float TEXTURE_WIDTH = 256.0f;
    private static final float TEXTURE_HEIGHT = 32.0f;
    private static final float BEAM_MIN_U = 0.875f;
    private static final float BEAM_MAX_U = 1.0f;
    private static final float PIXEL_SCALE = 0.0625f;
    private static final int MAX_HEIGHT = 256;
    private static final float DRAW_FADE_IN_RATE = 2.0f;
    private static final float DRAW_FADE_IN_POINT = 0.5f;
    private static final float DRAW_OPACITY_MULTIPLER = 0.7f;
    private static final float RING_RADIUS = 1.6f;
    private static final int RING_FRAME_SIZE = 16;
    private static final int RING_FRAME_COUNT = 10;
    private static final int BREAM_FRAME_COUNT = 31;
    private static final float BEAM_DRAW_START_RADIUS = 2.0f;
    private static final float BEAM_DRAW_END_RADIUS = 0.25f;
    private static final float BEAM_STRIKE_RADIUS = 1.0f;
    private static final float LINGER_RADIUS = 1.2f;
    private static final float SCORCH_MIN_U = 0.75f;
    private static final float SCORCH_MAX_U = 0.8125f;
    private static final float SCORCH_MIN_V = 0.5f;
    private static final float SCORCH_MAX_V = 1.0f;

    public RenderSunstrike(EntityRendererProvider.Context mgr) {
        super(mgr);
    }

    public ResourceLocation getTextureLocation(EntitySunstrike entity) {
        return TEXTURE;
    }

    public void render(EntitySunstrike sunstrike, float entityYaw, float delta, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        float maxY = (float)(256.0 - sunstrike.getY());
        if (maxY < 0.0f) {
            return;
        }
        RANDOMIZER.setSeed(sunstrike.getVariant());
        boolean isLingering = sunstrike.isLingering(delta);
        boolean isStriking = sunstrike.isStriking(delta);
        matrixStackIn.pushPose();
        VertexConsumer ivertexbuilder = bufferIn.getBuffer(MMRenderType.getGlowingEffect(TEXTURE));
        if (isLingering) {
            this.drawScorch(sunstrike, delta, matrixStackIn, ivertexbuilder, packedLightIn);
        } else if (isStriking) {
            this.drawStrike(sunstrike, maxY, delta, matrixStackIn, ivertexbuilder, packedLightIn);
        }
        matrixStackIn.popPose();
    }

    private void drawScorch(EntitySunstrike sunstrike, float delta, PoseStack matrixStack, VertexConsumer builder, int packedLightIn) {
        Level world = sunstrike.getCommandSenderWorld();
        double ex = sunstrike.xOld + (sunstrike.getX() - sunstrike.xOld) * (double)delta;
        double ey = sunstrike.yOld + (sunstrike.getY() - sunstrike.yOld) * (double)delta;
        double ez = sunstrike.zOld + (sunstrike.getZ() - sunstrike.zOld) * (double)delta;
        int minX = Mth.floor((double)(ex - (double)1.2f));
        int maxX = Mth.floor((double)(ex + (double)1.2f));
        int minY = Mth.floor((double)(ey - (double)1.2f));
        int maxY = Mth.floor((double)ey);
        int minZ = Mth.floor((double)(ez - (double)1.2f));
        int maxZ = Mth.floor((double)(ez + (double)1.2f));
        float opacityMultiplier = (0.6f + RANDOMIZER.nextFloat() * 0.2f) * (float)world.getMaxLocalRawBrightness(new BlockPos((int)ex, (int)ey, (int)ez));
        byte mirrorX = (byte)(RANDOMIZER.nextBoolean() ? -1 : 1);
        byte mirrorZ = (byte)(RANDOMIZER.nextBoolean() ? -1 : 1);
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)new BlockPos(minX, minY, minZ), (BlockPos)new BlockPos(maxX, maxY, maxZ))) {
            BlockState block = world.getBlockState(pos.below());
            if (block.isAir() || world.getMaxLocalRawBrightness(pos) <= 3) continue;
            this.drawScorchBlock(world, block, pos, ex, ey, ez, opacityMultiplier, mirrorX, mirrorZ, matrixStack, builder, packedLightIn);
        }
    }

    private void drawScorchBlock(Level world, BlockState block, BlockPos pos, double ex, double ey, double ez, float opacityMultiplier, byte mirrorX, byte mirrorZ, PoseStack matrixStack, VertexConsumer builder, int packedLightIn) {
        PoseStack.Pose matrixstack$entry = matrixStack.last();
        Matrix4f matrix4f = matrixstack$entry.pose();
        Matrix3f matrix3f = matrixstack$entry.normal();
        if (block.isRedstoneConductor((BlockGetter)world, pos)) {
            int bx = pos.getX();
            int by = pos.getY();
            int bz = pos.getZ();
            float opacity = (float)((1.0 - (ey - (double)by) / 2.0) * (double)opacityMultiplier);
            if (opacity >= 0.0f) {
                VoxelShape shape;
                if (opacity > 1.0f) {
                    opacity = 1.0f;
                }
                if (!(shape = block.getBlockSupportShape((BlockGetter)world, pos)).isEmpty()) {
                    AABB aabb = shape.bounds();
                    float minX = (float)((double)bx + aabb.minX - ex);
                    float maxX = (float)((double)bx + aabb.maxX - ex);
                    float y = (float)((double)by + aabb.minY - ey + 0.015625);
                    float minZ = (float)((double)bz + aabb.minZ - ez);
                    float maxZ = (float)((double)bz + aabb.maxZ - ez);
                    float minU = ((float)mirrorX * minX / 2.0f / 1.2f + 0.5f) * 0.0625f + 0.75f;
                    float maxU = ((float)mirrorX * maxX / 2.0f / 1.2f + 0.5f) * 0.0625f + 0.75f;
                    float minV = ((float)mirrorZ * minZ / 2.0f / 1.2f + 0.5f) * 0.5f + 0.5f;
                    float maxV = ((float)mirrorZ * maxZ / 2.0f / 1.2f + 0.5f) * 0.5f + 0.5f;
                    this.drawVertex(matrix4f, matrix3f, builder, minX, y, minZ, minU, minV, opacity, packedLightIn);
                    this.drawVertex(matrix4f, matrix3f, builder, minX, y, maxZ, minU, maxV, opacity, packedLightIn);
                    this.drawVertex(matrix4f, matrix3f, builder, maxX, y, maxZ, maxU, maxV, opacity, packedLightIn);
                    this.drawVertex(matrix4f, matrix3f, builder, maxX, y, minZ, maxU, minV, opacity, packedLightIn);
                }
            }
        }
    }

    private void drawStrike(EntitySunstrike sunstrike, float maxY, float delta, PoseStack matrixStack, VertexConsumer builder, int packedLightIn) {
        float opacity;
        float drawTime = sunstrike.getStrikeDrawTime(delta);
        float strikeTime = sunstrike.getStrikeDamageTime(delta);
        boolean drawing = sunstrike.isStrikeDrawing(delta);
        float f = opacity = drawing && drawTime < 0.5f ? drawTime * 2.0f : 1.0f;
        if (drawing) {
            opacity *= 0.7f;
        }
        this.drawRing(drawing, drawTime, strikeTime, opacity, matrixStack, builder, packedLightIn);
        matrixStack.mulPose(MathUtils.quatFromRotationXYZ(0.0f, -Minecraft.getInstance().gameRenderer.getMainCamera().getYRot(), 0.0f, true));
        this.drawBeam(drawing, drawTime, strikeTime, opacity, maxY, matrixStack, builder, packedLightIn);
    }

    private void drawRing(boolean drawing, float drawTime, float strikeTime, float opacity, PoseStack matrixStack, VertexConsumer builder, int packedLightIn) {
        int frame = (int)((drawing ? drawTime : strikeTime) * 11.0f);
        if (frame > 10) {
            frame = 10;
        }
        float minU = (float)(frame * 16) / 256.0f;
        float maxU = minU + 0.0625f;
        float minV = drawing ? 0.0f : 0.5f;
        float maxV = minV + 0.5f;
        float offset = 0.1f * (float)(frame % 2);
        PoseStack.Pose matrixstack$entry = matrixStack.last();
        Matrix4f matrix4f = matrixstack$entry.pose();
        Matrix3f matrix3f = matrixstack$entry.normal();
        this.drawVertex(matrix4f, matrix3f, builder, -1.6f + offset, 0.0f, -1.6f + offset, minU, minV, opacity, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, -1.6f + offset, 0.0f, 1.6f + offset, minU, maxV, opacity, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, 1.6f + offset, 0.0f, 1.6f + offset, maxU, maxV, opacity, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, 1.6f + offset, 0.0f, -1.6f + offset, maxU, minV, opacity, packedLightIn);
    }

    private void drawBeam(boolean drawing, float drawTime, float strikeTime, float opacity, float maxY, PoseStack matrixStack, VertexConsumer builder, int packedLightIn) {
        int frame;
        int n = frame = drawing ? 0 : (int)(strikeTime * 32.0f);
        if (frame > 31) {
            frame = 31;
        }
        float radius = 1.0f;
        if (drawing) {
            radius = -1.75f * drawTime + 2.0f;
        }
        float minV = (float)frame / 32.0f;
        float maxV = (float)(frame + 1) / 32.0f;
        PoseStack.Pose matrixstack$entry = matrixStack.last();
        Matrix4f matrix4f = matrixstack$entry.pose();
        Matrix3f matrix3f = matrixstack$entry.normal();
        this.drawVertex(matrix4f, matrix3f, builder, -radius, 0.0f, 0.0f, 0.875f, minV, opacity, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, -radius, maxY, 0.0f, 0.875f, maxV, opacity, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, radius, maxY, 0.0f, 1.0f, maxV, opacity, packedLightIn);
        this.drawVertex(matrix4f, matrix3f, builder, radius, 0.0f, 0.0f, 1.0f, minV, opacity, packedLightIn);
    }

    public void drawVertex(Matrix4f matrix, Matrix3f normals, VertexConsumer vertexBuilder, float offsetX, float offsetY, float offsetZ, float textureX, float textureY, float alpha, int packedLightIn) {
        VertexConsumer vertex = vertexBuilder.addVertex(matrix, offsetX, offsetY, offsetZ).setColor(1.0f, 1.0f, 1.0f, 1.0f * alpha).setUv(textureX, textureY).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLightIn);
        ClientUtils.transformNormals(vertex, normals, 1.0f, 0.0f, 1.0f);
    }
}

