/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.render.entity;

import com.bobmowzie.mowziesmobs.client.model.entity.ModelAxeAttack;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityAxeAttack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class RenderAxeAttack
extends EntityRenderer<EntityAxeAttack> {
    public static ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"mowziesmobs", (String)"textures/entity/wroughtnaut.png");
    ModelAxeAttack model = new ModelAxeAttack();

    public RenderAxeAttack(EntityRendererProvider.Context mgr) {
        super(mgr);
    }

    public ResourceLocation getTextureLocation(EntityAxeAttack entity) {
        return TEXTURE;
    }

    public void render(EntityAxeAttack axe, float entityYaw, float delta, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        LocalPlayer player;
        if (!((Boolean)ConfigHandler.CLIENT.customPlayerAnims.get()).booleanValue() && (player = Minecraft.getInstance().player) != null && player == axe.getCaster()) {
            matrixStackIn.pushPose();
            Vec3 prevAxePos = new Vec3(axe.xOld, axe.yOld, axe.zOld);
            Vec3 prevPlayerPos = new Vec3(player.xOld, player.yOld, player.zOld);
            Vec3 axePos = prevAxePos.add(axe.position().subtract(prevAxePos).scale((double)delta));
            Vec3 playerPos = prevPlayerPos.add(player.position().subtract(prevPlayerPos).scale((double)delta));
            Vec3 deltaPos = axePos.subtract(playerPos).scale(-1.0);
            matrixStackIn.translate(deltaPos.x(), deltaPos.y(), deltaPos.z());
            matrixStackIn.mulPose(new Quaternionf(new AxisAngle4f(player.getYRot() * (float)Math.PI / 180.0f, (Vector3fc)new Vector3f(0.0f, -1.0f, 0.0f))));
            VertexConsumer ivertexbuilder = bufferIn.getBuffer(RenderType.entitySolid((ResourceLocation)TEXTURE));
            this.model.setupAnim(axe, 0.0f, 0.0f, (float)axe.tickCount + delta, 0.0f, 0.0f);
            this.model.renderToBuffer(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.NO_OVERLAY, -1);
            matrixStackIn.popPose();
        }
    }
}

