/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.model.entity;

import com.bobmowzie.mowziesmobs.server.entity.effects.EntityPoisonBall;
import com.ilexiconn.llibrary.client.model.tools.AdvancedModelBase;
import com.ilexiconn.llibrary.client.model.tools.AdvancedModelRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.phys.Vec3;

public class ModelPoisonBall<T extends EntityPoisonBall>
extends AdvancedModelBase<T> {
    private final AdvancedModelRenderer inner;
    private final AdvancedModelRenderer outer;

    public ModelPoisonBall() {
        this.textureWidth = 32;
        this.textureHeight = 32;
        this.inner = new AdvancedModelRenderer(this, 0, 16);
        this.inner.setRotationPoint(0.0f, 3.5f, 0.0f);
        this.inner.addBox(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f, 0.0f, false);
        this.outer = new AdvancedModelRenderer(this, 0, 0);
        this.outer.setRotationPoint(0.0f, 3.5f, 0.0f);
        this.outer.addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, 0.0f, false);
        this.inner.setOpacity(1.0f);
        this.outer.setOpacity(0.6f);
    }

    public void renderToBuffer(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, int color) {
        this.inner.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, color);
        this.outer.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, color);
    }

    @Override
    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        T poisonBall = entityIn;
        float delta = ageInTicks - (float)((EntityPoisonBall)entityIn).tickCount;
        Vec3 prevV = new Vec3(((EntityPoisonBall)poisonBall).prevMotionX, ((EntityPoisonBall)poisonBall).prevMotionY, ((EntityPoisonBall)poisonBall).prevMotionZ);
        Vec3 dv = prevV.add(poisonBall.getDeltaMovement().subtract(prevV).scale((double)delta));
        double d = Math.sqrt(dv.x * dv.x + dv.y * dv.y + dv.z * dv.z);
        if (d != 0.0) {
            double a = dv.y / d;
            a = Math.max(-1.0, Math.min(1.0, a));
            float pitch = -((float)Math.asin(a));
            this.inner.rotateAngleX = pitch + 1.5707964f;
            this.outer.rotateAngleX = pitch + 1.5707964f;
        }
    }

    public void setRotationAngle(ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.x = x;
        modelRenderer.y = y;
        modelRenderer.z = z;
    }
}

