/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.gui;

import com.bobmowzie.mowziesmobs.server.entity.sculptor.EntitySculptor;
import com.bobmowzie.mowziesmobs.server.inventory.ContainerSculptorTrade;
import com.bobmowzie.mowziesmobs.server.inventory.InventoryOneInput;
import com.bobmowzie.mowziesmobs.server.inventory.InventorySculptor;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import com.bobmowzie.mowziesmobs.server.message.MessageSculptorTrade;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.PacketDistributor;

public final class GuiSculptorTrade
extends AbstractContainerScreen<ContainerSculptorTrade>
implements InventoryOneInput.ChangeListener {
    private static final ResourceLocation TEXTURE_TRADE = ResourceLocation.fromNamespaceAndPath((String)"mowziesmobs", (String)"textures/gui/container/umvuthi_trade.png");
    private final EntitySculptor sculptor;
    private final InventorySculptor inventory;
    private final ItemStack output = new ItemStack((ItemLike)ItemHandler.EARTHREND_GAUNTLET.get());
    private Button beginButton;
    private boolean prevBlocked;

    public GuiSculptorTrade(ContainerSculptorTrade screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.sculptor = screenContainer.getSculptor();
        this.inventory = screenContainer.getInventorySculptor();
        this.inventory.addListener(this);
    }

    protected void init() {
        super.init();
        String text = I18n.get((String)"entity.mowziesmobs.sculptor.trade.button.text", (Object[])new Object[0]);
        this.beginButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)text), this::actionPerformed).pos(this.leftPos + 115, this.topPos + 52).size(56, 20).build());
        this.updateButton();
    }

    private void actionPerformed(Button button) {
        if (button == this.beginButton) {
            PacketDistributor.sendToServer((CustomPacketPayload)new MessageSculptorTrade(this.sculptor.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int x, int y) {
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(TEXTURE_TRADE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        this.sculptor.renderingInGUI = true;
        InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)guiGraphics, (int)(this.leftPos + 8), (int)(this.topPos + 8), (int)(this.leftPos + 59), (int)(this.topPos + 69), (int)14, (float)0.0f, (float)x, (float)y, (LivingEntity)this.sculptor);
        this.sculptor.renderingInGUI = false;
    }

    protected void renderLabels(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.drawString(this.font, this.title, (int)((float)this.imageWidth / 2.0f - (float)this.font.width((FormattedText)this.title) / 2.0f) + 30, 6, 0x404040, false);
        guiGraphics.drawString(this.font, I18n.get((String)"container.inventory", (Object[])new Object[0]), 8, this.imageHeight - 96 + 2, 0x404040, false);
        if (this.sculptor.isTestObstructed()) {
            String blocked = I18n.get((String)"entity.mowziesmobs.sculptor.trade.blocked", (Object[])new Object[0]);
            guiGraphics.drawString(this.font, blocked, (int)((float)this.imageWidth / 2.0f - (float)this.font.width(blocked) / 2.0f) + 30, 42, 0x404040, false);
        }
        if (this.prevBlocked != this.sculptor.isTestObstructed()) {
            this.onChange(this.inventory);
        }
        this.prevBlocked = this.sculptor.isTestObstructed();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        ItemStack inSlot = this.inventory.getItem(0);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 100.0f);
        guiGraphics.renderItem(this.sculptor.getDesires(), this.leftPos + 68, this.topPos + 24);
        guiGraphics.renderItemDecorations(this.font, this.sculptor.getDesires(), this.leftPos + 68, this.topPos + 24);
        guiGraphics.renderItem(this.output, this.leftPos + 134, this.topPos + 24);
        guiGraphics.renderItemDecorations(this.font, this.output, this.leftPos + 134, this.topPos + 24);
        if (this.isHovering(68, 24, 16, 16, mouseX, mouseY)) {
            guiGraphics.renderTooltip(this.font, this.sculptor.getDesires(), mouseX, mouseY);
        } else if (this.isHovering(134, 24, 16, 16, mouseX, mouseY)) {
            guiGraphics.renderTooltip(this.font, this.output, mouseX, mouseY);
        }
        if (this.beginButton.isMouseOver((double)mouseX, (double)mouseY)) {
            guiGraphics.renderComponentHoverEffect(this.font, this.getHoverText(), mouseX, mouseY);
        }
        guiGraphics.pose().popPose();
    }

    @Override
    public void onChange(Container inv) {
        this.beginButton.active = this.sculptor.doesItemSatisfyDesire(inv.getItem(0)) && !this.sculptor.isTestObstructed();
    }

    private void updateButton() {
        this.beginButton.setMessage((Component)Component.translatable((String)I18n.get((String)"entity.mowziesmobs.sculptor.trade.button.text", (Object[])new Object[0])));
    }

    private Style getHoverText() {
        MutableComponent text = Component.translatable((String)I18n.get((String)"entity.mowziesmobs.sculptor.trade.button.hover", (Object[])new Object[0]));
        return text.getStyle().withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)text));
    }
}

