/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.i_architecture.registry;

import java.util.function.BiFunction;
import net.createmod.catnip.math.VoxelShaper;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class IAShapes {
    public static final VoxelShaper ORNATE_BRICKS = IAShapes.shape(0.0, 0.0, 0.0, 16.0, 16.0, 4.0).forDirectional(Direction.SOUTH);
    public static final VoxelShaper FOGGY_GLASS_TILES_PANE = IAShapes.shape(0.0, 0.0, 4.0, 16.0, 16.0, 12.0).forDirectional(Direction.NORTH);
    public static final VoxelShaper CATWALK_STAIRS = IAShapes.shape(0.0, 6.0, 0.0, 16.0, 8.0, 8.0).add(0.0, 14.0, 8.0, 16.0, 16.0, 16.0).forDirectional(Direction.NORTH);
    public static VoxelShape CATWALK = IAShapes.cuboid(0.0, 8.0, 0.0, 16.0, 16.0, 16.0);
    public static VoxelShape EMPTY = IAShapes.cuboid(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

    private static Builder shape(VoxelShape shape) {
        return new Builder(shape);
    }

    private static Builder shape(double x1, double y1, double z1, double x2, double y2, double z2) {
        return IAShapes.shape(IAShapes.cuboid(x1, y1, z1, x2, y2, z2));
    }

    private static VoxelShape cuboid(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Block.box((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
    }

    public static class Builder {
        private VoxelShape shape;

        public Builder(VoxelShape shape) {
            this.shape = shape;
        }

        public Builder add(VoxelShape shape) {
            this.shape = Shapes.or((VoxelShape)this.shape, (VoxelShape)shape);
            return this;
        }

        public Builder add(double x1, double y1, double z1, double x2, double y2, double z2) {
            return this.add(IAShapes.cuboid(x1, y1, z1, x2, y2, z2));
        }

        public Builder erase(double x1, double y1, double z1, double x2, double y2, double z2) {
            this.shape = Shapes.join((VoxelShape)this.shape, (VoxelShape)IAShapes.cuboid(x1, y1, z1, x2, y2, z2), (BooleanOp)BooleanOp.ONLY_FIRST);
            return this;
        }

        public VoxelShape build() {
            return this.shape;
        }

        public VoxelShaper build(BiFunction<VoxelShape, Direction, VoxelShaper> factory, Direction direction) {
            return factory.apply(this.shape, direction);
        }

        public VoxelShaper build(BiFunction<VoxelShape, Direction.Axis, VoxelShaper> factory, Direction.Axis axis) {
            return factory.apply(this.shape, axis);
        }

        public VoxelShaper forDirectional(Direction direction) {
            return this.build(VoxelShaper::forDirectional, direction);
        }

        public VoxelShaper forAxis() {
            return this.build(VoxelShaper::forAxis, Direction.Axis.Y);
        }

        public VoxelShaper forHorizontalAxis() {
            return this.build(VoxelShaper::forHorizontalAxis, Direction.Axis.Z);
        }

        public VoxelShaper forHorizontal(Direction direction) {
            return this.build(VoxelShaper::forHorizontal, direction);
        }

        public VoxelShaper forDirectional() {
            return this.forDirectional(Direction.UP);
        }
    }
}

