/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.i_architecture.datagen.recipes;

import com.drmangotea.i_architecture.IndustrializedArchitecture;
import com.drmangotea.i_architecture.datagen.recipes.IARecipeProvider;
import com.drmangotea.i_architecture.registry.IABlocks;
import com.drmangotea.i_architecture.registry.IAItems;
import com.google.common.base.Supplier;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.decoration.palettes.AllPaletteBlocks;
import com.simibubi.create.foundation.data.recipe.CompatMetals;
import com.simibubi.create.foundation.data.recipe.Mods;
import com.simibubi.create.foundation.mixin.accessor.MappedRegistryAccessor;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.registry.RegisteredObjectsHelper;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.neoforged.neoforge.common.conditions.NotCondition;
import org.jetbrains.annotations.Nullable;

public class IAStandardRecipeGen
extends IARecipeProvider {
    private IARecipeProvider.Marker MATERIALS = this.enterFolder("materials");
    public static final Map<String, ItemLike> DYES_FROM_COLOR = new HashMap<String, ItemLike>();
    IARecipeProvider.GeneratedRecipe DARK_BRICKS = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)IABlocks.DARK_BRICKS).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> IAItems.DARK_BRICK.get())).viaShaped(b -> b.define(Character.valueOf('B'), IARecipeProvider.I.darkBrick()).pattern("BB ").pattern("BB ").pattern("   "));
    IARecipeProvider.GeneratedRecipe SANDY_BRICKS = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)IABlocks.SANDY_BRICKS).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> IAItems.SANDY_BRICK.get())).viaShaped(b -> b.define(Character.valueOf('B'), IARecipeProvider.I.sandyBrick()).pattern("BB ").pattern("BB ").pattern("   "));
    IARecipeProvider.GeneratedRecipe ASH_BRICKS = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)IABlocks.ASH_BRICKS).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> IAItems.ASH_BRICK.get())).viaShaped(b -> b.define(Character.valueOf('B'), IARecipeProvider.I.ashBrick()).pattern("BB ").pattern("BB ").pattern("   "));
    IARecipeProvider.GeneratedRecipe SOOT_BRICKS = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)IABlocks.SOOT_BRICKS).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> IAItems.SOOT_BRICK.get())).viaShaped(b -> b.define(Character.valueOf('B'), IARecipeProvider.I.sootBrick()).pattern("BB ").pattern("BB ").pattern("   "));
    IARecipeProvider.GeneratedRecipe MUDDY_BRICKS = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)IABlocks.MUDDY_BRICKS).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> IAItems.MUDDY_BRICK.get())).viaShaped(b -> b.define(Character.valueOf('B'), IARecipeProvider.I.muddyBrick()).pattern("BB ").pattern("BB ").pattern("   "));
    IARecipeProvider.GeneratedRecipe HALF_DARK_BRICKS = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)IABlocks.HALF_DARK_BRICKS).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> IAItems.DARK_BRICK.get())).viaShaped(b -> b.define(Character.valueOf('B'), IABlocks.DARK_BRICKS_SET.slab).define(Character.valueOf('G'), IABlocks.CERAMIC_TILE_SET.slab).pattern("B  ").pattern("G  ").pattern("   "));
    IARecipeProvider.GeneratedRecipe HALF_CERAMIC_TILE = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)IABlocks.HALF_CERAMIC_TILE).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> IAItems.DARK_BRICK.get())).viaShaped(b -> b.define(Character.valueOf('B'), IABlocks.DARK_BRICKS_SET.slab).define(Character.valueOf('G'), IABlocks.CERAMIC_TILE_SET.slab).pattern("G  ").pattern("B  ").pattern("   "));
    IARecipeProvider.GeneratedRecipe COMPOSITE_DARK_BRICKS = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)IABlocks.COMPOSITE_DARK_BRICKS).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> IAItems.DARK_BRICK.get())).viaShaped(b -> b.define(Character.valueOf('B'), IARecipeProvider.I.darkBrick()).define(Character.valueOf('C'), IARecipeProvider.I.ceramicTile()).pattern("CB ").pattern("CB ").pattern("   "));
    IARecipeProvider.GeneratedRecipe CERAMIC_TILES = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)IABlocks.CERAMIC_TILES).returns(2).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> IAItems.CERAMIC_TILE.get())).viaShaped(b -> b.define(Character.valueOf('B'), IARecipeProvider.I.ceramicTile()).pattern("BB ").pattern("BB ").pattern("   "));
    IARecipeProvider.GeneratedRecipe ROOF_SHINGLES = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)IABlocks.ROOF_SHINGLES).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> IAItems.ROOF_SHINGLE.get())).viaShaped(b -> b.define(Character.valueOf('B'), IARecipeProvider.I.roofShingle()).pattern("BB ").pattern("BB ").pattern("   "));
    IARecipeProvider.GeneratedRecipe FOGGY_GLASS_TILES = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)IABlocks.FOGGY_GLASS_TILES).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> IAItems.FOGGY_GLASS_TILE.get())).viaShaped(b -> b.define(Character.valueOf('B'), IARecipeProvider.I.foggyGlassTiles()).pattern("BB ").pattern("BB ").pattern("   "));
    IARecipeProvider.GeneratedRecipe METAL_PLATE_BLOCK = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)IABlocks.METAL_PLATE_BLOCK.getNormal()).returns(8).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> IAItems.INDUSTRIAL_IRON_INGOT.get())).viaShaped(b -> b.define(Character.valueOf('B'), IARecipeProvider.I.industrialIron()).pattern("BB ").pattern("BB ").pattern("   "));
    IARecipeProvider.GeneratedRecipe METAL_PLATE_LIGHT = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)IABlocks.METAL_PLATE_LIGHT.getNormal()).returns(2).unlockedBy((Supplier<? extends ItemLike>)((Supplier)IABlocks.METAL_PLATE_BLOCK::getNormal)).viaShaped(b -> b.define(Character.valueOf('B'), IARecipeProvider.I.metalPlateBlock()).define(Character.valueOf('G'), (ItemLike)Items.GLOWSTONE_DUST).pattern("BG ").pattern("GB ").pattern("   "));
    IARecipeProvider.GeneratedRecipe BRASS_LIGHT = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)IABlocks.BRASS_LIGHT).returns(2).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((ItemEntry)AllItems.BRASS_INGOT).get())).viaShaped(b -> b.define(Character.valueOf('B'), IARecipeProvider.I.brassPlating()).define(Character.valueOf('G'), (ItemLike)Items.GLOWSTONE_DUST).pattern("BG ").pattern("GB ").pattern("   "));
    IARecipeProvider.GeneratedRecipe METAL_VENT = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)IABlocks.METAL_VENT.getNormal()).returns(2).unlockedBy((Supplier<? extends ItemLike>)((Supplier)IABlocks.METAL_PLATE_BLOCK::getNormal)).viaShaped(b -> b.define(Character.valueOf('B'), IARecipeProvider.I.metalPlateBlock()).define(Character.valueOf('G'), (ItemLike)Blocks.IRON_BARS).pattern("BG ").pattern("GB ").pattern("   "));
    IARecipeProvider.GeneratedRecipe METAL_WINDOW = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)IABlocks.METAL_WINDOW.getNormal()).returns(2).unlockedBy((Supplier<? extends ItemLike>)((Supplier)IABlocks.METAL_PLATE_BLOCK::getNormal)).viaShaped(b -> b.define(Character.valueOf('B'), IARecipeProvider.I.metalPlateBlock()).define(Character.valueOf('G'), (ItemLike)AllPaletteBlocks.FRAMED_GLASS.get()).pattern("BG ").pattern("GB ").pattern("   "));
    IARecipeProvider.GeneratedRecipe BRASS_WINDOW = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)IABlocks.BRASS_WINDOW).returns(2).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> ((ItemEntry)AllItems.BRASS_INGOT).get())).viaShaped(b -> b.define(Character.valueOf('B'), IARecipeProvider.I.brassPlating()).define(Character.valueOf('G'), (ItemLike)AllPaletteBlocks.FRAMED_GLASS.get()).pattern("BG ").pattern("GB ").pattern("   "));
    IARecipeProvider.GeneratedRecipe METAL_DOOR = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)IABlocks.METAL_DOOR.getNormal()).unlockedBy((Supplier<? extends ItemLike>)((Supplier)IABlocks.METAL_PLATE_BLOCK::getNormal)).viaShaped(b -> b.define(Character.valueOf('B'), IARecipeProvider.I.metalPlateBlock()).pattern("BB ").pattern("BB ").pattern("BB "));
    IARecipeProvider.GeneratedRecipe FOLDING_METAL_DOOR = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)IABlocks.FOLDING_METAL_DOOR.getNormal()).unlockedBy((Supplier<? extends ItemLike>)((Supplier)IABlocks.METAL_PLATE_BLOCK::getRusted)).viaShaped(b -> b.define(Character.valueOf('B'), IARecipeProvider.I.metalPlateBlock()).pattern("B B").pattern("B B").pattern("B B"));
    IARecipeProvider.GeneratedRecipe BRASS_DOOR = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)IABlocks.BRASS_DOOR).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> IABlocks.BRASS_PLATING.get())).viaShaped(b -> b.define(Character.valueOf('B'), IARecipeProvider.I.brassPlating()).pattern("BB ").pattern("BB ").pattern("BB "));
    IARecipeProvider.GeneratedRecipe FOLDING_BRASS_DOOR = this.create((ItemProviderEntry<? extends ItemLike, ? extends ItemLike>)IABlocks.FOLDING_BRASS_DOOR).unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> IABlocks.BRASS_PLATING.get())).viaShaped(b -> b.define(Character.valueOf('B'), IARecipeProvider.I.brassPlating()).pattern("B B").pattern("B B").pattern("B B"));
    String currentFolder = "";

    IARecipeProvider.Marker enterFolder(String folder) {
        this.currentFolder = folder;
        return new IARecipeProvider.Marker();
    }

    GeneratedRecipeBuilder create(Supplier<ItemLike> result) {
        return new GeneratedRecipeBuilder(this.currentFolder, result);
    }

    GeneratedRecipeBuilder create(ResourceLocation result) {
        return new GeneratedRecipeBuilder(this.currentFolder, result);
    }

    GeneratedRecipeBuilder create(ItemProviderEntry<? extends ItemLike, ? extends ItemLike> result) {
        return this.create((Supplier<ItemLike>)((Supplier)() -> result.get()));
    }

    IARecipeProvider.GeneratedRecipe createSpecial(Function<CraftingBookCategory, Recipe<?>> builder, String recipeType, String path) {
        ResourceLocation location = IndustrializedArchitecture.asResource(recipeType + "/" + this.currentFolder + "/" + path);
        return this.register(consumer -> {
            SpecialRecipeBuilder b = SpecialRecipeBuilder.special((Function)builder);
            b.save(consumer, location.toString());
        });
    }

    IARecipeProvider.GeneratedRecipe blastCrushedMetal(Supplier<? extends ItemLike> result, Supplier<? extends ItemLike> ingredient) {
        return this.create((Supplier<ItemLike>)((Supplier)() -> result.get())).withSuffix("_from_crushed").viaCooking(ingredient).rewardXP(0.1f).inBlastFurnace();
    }

    IARecipeProvider.GeneratedRecipe blastModdedCrushedMetal(ItemEntry<? extends Item> ingredient, CompatMetals metal) {
        for (Mods mod : metal.getMods()) {
            String metalName = metal.getName(mod);
            ResourceLocation ingot = mod.ingotOf(metalName);
            String modId = mod.getId();
            this.create(ingot).withSuffix("_compat_" + modId).whenModLoaded(modId).viaCooking((Supplier<? extends ItemLike>)((Supplier)() -> ingredient.get())).rewardXP(0.1f).inBlastFurnace();
        }
        return null;
    }

    IARecipeProvider.GeneratedRecipe recycleGlass(BlockEntry<? extends Block> ingredient) {
        return this.create((Supplier<ItemLike>)((Supplier)() -> Blocks.GLASS)).withSuffix("_from_" + ingredient.getId().getPath()).viaCooking((Supplier<? extends ItemLike>)((Supplier)() -> ingredient.get())).forDuration(50).inFurnace();
    }

    IARecipeProvider.GeneratedRecipe recycleGlassPane(BlockEntry<? extends Block> ingredient) {
        return this.create((Supplier<ItemLike>)((Supplier)() -> Blocks.GLASS_PANE)).withSuffix("_from_" + ingredient.getId().getPath()).viaCooking((Supplier<? extends ItemLike>)((Supplier)() -> ingredient.get())).forDuration(50).inFurnace();
    }

    IARecipeProvider.GeneratedRecipe metalCompacting(List<ItemProviderEntry<? extends ItemLike, ? extends ItemLike>> variants, List<Supplier<TagKey<Item>>> ingredients) {
        IARecipeProvider.GeneratedRecipe result = null;
        int i = 0;
        while (i + 1 < variants.size()) {
            ItemProviderEntry<? extends ItemLike, ? extends ItemLike> currentEntry = variants.get(i);
            ItemProviderEntry<? extends ItemLike, ? extends ItemLike> nextEntry = variants.get(i + 1);
            Supplier<TagKey<Item>> currentIngredient = ingredients.get(i);
            Supplier<TagKey<Item>> nextIngredient = ingredients.get(i + 1);
            result = this.create(nextEntry).withSuffix("_from_compacting").unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> currentEntry.get())).viaShaped(b -> b.pattern("###").pattern("###").pattern("###").define(Character.valueOf('#'), (TagKey)currentIngredient.get()));
            result = this.create(currentEntry).returns(9).withSuffix("_from_decompacting").unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> nextEntry.get())).viaShapeless(b -> b.requires((TagKey)nextIngredient.get()));
            ++i;
        }
        return result;
    }

    IARecipeProvider.GeneratedRecipe conversionCycle(List<ItemProviderEntry<? extends ItemLike, ? extends ItemLike>> cycle) {
        IARecipeProvider.GeneratedRecipe result = null;
        for (int i = 0; i < cycle.size(); ++i) {
            ItemProviderEntry<? extends ItemLike, ? extends ItemLike> currentEntry = cycle.get(i);
            ItemProviderEntry<? extends ItemLike, ? extends ItemLike> nextEntry = cycle.get((i + 1) % cycle.size());
            result = this.create(nextEntry).withSuffix("_from_conversion").unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> currentEntry.get())).viaShapeless(b -> b.requires((ItemLike)currentEntry.get()));
        }
        return result;
    }

    IARecipeProvider.GeneratedRecipe clearData(ItemProviderEntry<? extends ItemLike, ? extends ItemLike> item) {
        return this.create(item).withSuffix("_clear").unlockedBy((Supplier<? extends ItemLike>)((Supplier)() -> item.get())).viaShapeless(b -> b.requires((ItemLike)item.get()));
    }

    public IAStandardRecipeGen(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    static {
        DYES_FROM_COLOR.put("white", (ItemLike)Items.WHITE_DYE);
        DYES_FROM_COLOR.put("blue", (ItemLike)Items.BLUE_DYE);
        DYES_FROM_COLOR.put("light_blue", (ItemLike)Items.LIGHT_BLUE_DYE);
        DYES_FROM_COLOR.put("red", (ItemLike)Items.RED_DYE);
        DYES_FROM_COLOR.put("green", (ItemLike)Items.GREEN_DYE);
        DYES_FROM_COLOR.put("lime", (ItemLike)Items.LIME_DYE);
        DYES_FROM_COLOR.put("pink", (ItemLike)Items.PINK_DYE);
        DYES_FROM_COLOR.put("magenta", (ItemLike)Items.MAGENTA_DYE);
        DYES_FROM_COLOR.put("yellow", (ItemLike)Items.YELLOW_DYE);
        DYES_FROM_COLOR.put("gray", (ItemLike)Items.GRAY_DYE);
        DYES_FROM_COLOR.put("light_gray", (ItemLike)Items.LIGHT_GRAY_DYE);
        DYES_FROM_COLOR.put("brown", (ItemLike)Items.BROWN_DYE);
        DYES_FROM_COLOR.put("cyan", (ItemLike)Items.CYAN_DYE);
        DYES_FROM_COLOR.put("purple", (ItemLike)Items.PURPLE_DYE);
        DYES_FROM_COLOR.put("orange", (ItemLike)Items.ORANGE_DYE);
        DYES_FROM_COLOR.put("black", (ItemLike)Items.BLACK_DYE);
    }

    class GeneratedRecipeBuilder {
        private String path;
        private String suffix;
        private Supplier<? extends ItemLike> result;
        private ResourceLocation compatDatagenOutput;
        List<ICondition> recipeConditions;
        private Supplier<ItemPredicate> unlockedBy;
        private int amount;

        private GeneratedRecipeBuilder(String path) {
            this.path = path;
            this.recipeConditions = new ArrayList<ICondition>();
            this.suffix = "";
            this.amount = 1;
        }

        public GeneratedRecipeBuilder(String path, Supplier<? extends ItemLike> result) {
            this(path);
            this.result = result;
        }

        public GeneratedRecipeBuilder(String path, ResourceLocation result) {
            this(path);
            this.compatDatagenOutput = result;
        }

        GeneratedRecipeBuilder returns(int amount) {
            this.amount = amount;
            return this;
        }

        GeneratedRecipeBuilder unlockedBy(Supplier<? extends ItemLike> item) {
            this.unlockedBy = () -> ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)item.get()}).build();
            return this;
        }

        GeneratedRecipeBuilder unlockedByTag(Supplier<TagKey<Item>> tag) {
            this.unlockedBy = () -> ItemPredicate.Builder.item().of((TagKey)tag.get()).build();
            return this;
        }

        GeneratedRecipeBuilder whenModLoaded(String modid) {
            return this.withCondition((ICondition)new ModLoadedCondition(modid));
        }

        GeneratedRecipeBuilder whenModMissing(String modid) {
            return this.withCondition((ICondition)new NotCondition((ICondition)new ModLoadedCondition(modid)));
        }

        GeneratedRecipeBuilder withCondition(ICondition condition) {
            this.recipeConditions.add(condition);
            return this;
        }

        GeneratedRecipeBuilder withSuffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        IARecipeProvider.GeneratedRecipe viaShaped(UnaryOperator<ShapedRecipeBuilder> builder) {
            return IAStandardRecipeGen.this.register(consumer -> {
                ShapedRecipeBuilder b = (ShapedRecipeBuilder)builder.apply(ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)this.result.get()), (int)this.amount));
                if (this.unlockedBy != null) {
                    b.unlockedBy("has_item", IAStandardRecipeGen.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{(ItemPredicate)this.unlockedBy.get()}));
                }
                b.save(consumer, this.createLocation("crafting"));
            });
        }

        IARecipeProvider.GeneratedRecipe viaShapeless(UnaryOperator<ShapelessRecipeBuilder> builder) {
            return IAStandardRecipeGen.this.register(recipeOutput -> {
                ShapelessRecipeBuilder b = (ShapelessRecipeBuilder)builder.apply(ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)this.result.get()), (int)this.amount));
                if (this.unlockedBy != null) {
                    b.unlockedBy("has_item", IAStandardRecipeGen.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{(ItemPredicate)this.unlockedBy.get()}));
                }
                RecipeOutput conditionalOutput = recipeOutput.withConditions(this.recipeConditions.toArray(new ICondition[0]));
                b.save(recipeOutput, this.createLocation("crafting"));
            });
        }

        IARecipeProvider.GeneratedRecipe viaNetheriteSmithing(Supplier<? extends Item> base, Supplier<Ingredient> upgradeMaterial) {
            return IAStandardRecipeGen.this.register(consumer -> {
                SmithingTransformRecipeBuilder b = SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)base.get()}), (Ingredient)((Ingredient)upgradeMaterial.get()), (RecipeCategory)RecipeCategory.COMBAT, (Item)((ItemLike)this.result.get()).asItem());
                b.unlocks("has_item", IAStandardRecipeGen.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)base.get()}).build()}));
                b.save(consumer, this.createLocation("crafting"));
            });
        }

        private ResourceLocation createSimpleLocation(String recipeType) {
            return IndustrializedArchitecture.asResource(recipeType + "/" + this.getRegistryName().getPath() + this.suffix);
        }

        private ResourceLocation createLocation(String recipeType) {
            return IndustrializedArchitecture.asResource(recipeType + "/" + this.path + "/" + this.getRegistryName().getPath() + this.suffix);
        }

        private ResourceLocation getRegistryName() {
            return this.compatDatagenOutput == null ? RegisteredObjectsHelper.getKeyOrThrow((Item)((ItemLike)this.result.get()).asItem()) : this.compatDatagenOutput;
        }

        GeneratedCookingRecipeBuilder viaCooking(Supplier<? extends ItemLike> item) {
            return this.unlockedBy(item).viaCookingIngredient((Supplier<Ingredient>)((Supplier)() -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)item.get()})));
        }

        GeneratedCookingRecipeBuilder viaCookingTag(Supplier<TagKey<Item>> tag) {
            return this.unlockedByTag(tag).viaCookingIngredient((Supplier<Ingredient>)((Supplier)() -> Ingredient.of((TagKey)((TagKey)tag.get()))));
        }

        GeneratedCookingRecipeBuilder viaCookingIngredient(Supplier<Ingredient> ingredient) {
            return new GeneratedCookingRecipeBuilder(ingredient);
        }

        class GeneratedCookingRecipeBuilder {
            private Supplier<Ingredient> ingredient;
            private float exp;
            private int cookingTime;

            GeneratedCookingRecipeBuilder(Supplier<Ingredient> ingredient) {
                this.ingredient = ingredient;
                this.cookingTime = 200;
                this.exp = 0.0f;
            }

            GeneratedCookingRecipeBuilder forDuration(int duration) {
                this.cookingTime = duration;
                return this;
            }

            GeneratedCookingRecipeBuilder rewardXP(float xp) {
                this.exp = xp;
                return this;
            }

            IARecipeProvider.GeneratedRecipe inFurnace() {
                return this.inFurnace(b -> b);
            }

            IARecipeProvider.GeneratedRecipe inFurnace(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
                return this.create(RecipeSerializer.SMELTING_RECIPE, builder, SmeltingRecipe::new, 1.0f);
            }

            IARecipeProvider.GeneratedRecipe inSmoker() {
                return this.inSmoker(b -> b);
            }

            IARecipeProvider.GeneratedRecipe inSmoker(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
                this.create(RecipeSerializer.SMELTING_RECIPE, builder, SmeltingRecipe::new, 1.0f);
                this.create(RecipeSerializer.CAMPFIRE_COOKING_RECIPE, builder, CampfireCookingRecipe::new, 3.0f);
                return this.create(RecipeSerializer.SMOKING_RECIPE, builder, SmokingRecipe::new, 0.5f);
            }

            IARecipeProvider.GeneratedRecipe inBlastFurnace() {
                return this.inBlastFurnace(b -> b);
            }

            IARecipeProvider.GeneratedRecipe inBlastFurnace(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
                this.create(RecipeSerializer.SMELTING_RECIPE, builder, SmeltingRecipe::new, 1.0f);
                return this.create(RecipeSerializer.BLASTING_RECIPE, builder, BlastingRecipe::new, 0.5f);
            }

            private <T extends AbstractCookingRecipe> IARecipeProvider.GeneratedRecipe create(RecipeSerializer<T> serializer, UnaryOperator<SimpleCookingRecipeBuilder> builder, AbstractCookingRecipe.Factory<T> factory, float cookingTimeModifier) {
                return IAStandardRecipeGen.this.register(recipeOutput -> {
                    boolean isOtherMod = GeneratedRecipeBuilder.this.compatDatagenOutput != null;
                    SimpleCookingRecipeBuilder b = (SimpleCookingRecipeBuilder)builder.apply(SimpleCookingRecipeBuilder.generic((Ingredient)((Ingredient)this.ingredient.get()), (RecipeCategory)RecipeCategory.MISC, (ItemLike)(isOtherMod ? Items.DIRT : (ItemLike)GeneratedRecipeBuilder.this.result.get()), (float)this.exp, (int)((int)((float)this.cookingTime * cookingTimeModifier)), (RecipeSerializer)serializer, (AbstractCookingRecipe.Factory)factory));
                    if (GeneratedRecipeBuilder.this.unlockedBy != null) {
                        b.unlockedBy("has_item", IAStandardRecipeGen.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{(ItemPredicate)GeneratedRecipeBuilder.this.unlockedBy.get()}));
                    }
                    RecipeOutput conditionalOutput = recipeOutput.withConditions(GeneratedRecipeBuilder.this.recipeConditions.toArray(new ICondition[0]));
                    b.save((RecipeOutput)(isOtherMod ? new ModdedCookingRecipeOutput(conditionalOutput, GeneratedRecipeBuilder.this.compatDatagenOutput) : conditionalOutput), GeneratedRecipeBuilder.this.createSimpleLocation(RegisteredObjectsHelper.getKeyOrThrow((RecipeSerializer)serializer).getPath()));
                });
            }
        }
    }

    @ParametersAreNonnullByDefault
    @MethodsReturnNonnullByDefault
    private record ModdedCookingRecipeOutput(RecipeOutput wrapped, ResourceLocation outputOverride) implements RecipeOutput
    {
        public Advancement.Builder advancement() {
            return this.wrapped.advancement();
        }

        public void accept(ResourceLocation id, Recipe<?> recipe, @Nullable AdvancementHolder advancement, ICondition ... conditions) {
            this.wrapped.accept(id, (Recipe)new ModdedCookingRecipeOutputShim(recipe, this.outputOverride), advancement, conditions);
        }
    }

    @ParametersAreNonnullByDefault
    @MethodsReturnNonnullByDefault
    private static class ModdedCookingRecipeOutputShim
    implements Recipe<RecipeInput> {
        private static final Map<RecipeType<?>, Serializer> serializers = new ConcurrentHashMap();
        private final Recipe<?> wrapped;
        private final ResourceLocation overrideID;

        private ModdedCookingRecipeOutputShim(Recipe<?> wrapped, ResourceLocation overrideID) {
            this.wrapped = wrapped;
            this.overrideID = overrideID;
        }

        public boolean matches(RecipeInput recipeInput, Level level) {
            throw new AssertionError((Object)"Only for datagen output");
        }

        public ItemStack assemble(RecipeInput input, HolderLookup.Provider registries) {
            throw new AssertionError((Object)"Only for datagen output");
        }

        public boolean canCraftInDimensions(int pWidth, int pHeight) {
            throw new AssertionError((Object)"Only for datagen output");
        }

        public ItemStack getResultItem(HolderLookup.Provider registries) {
            throw new AssertionError((Object)"Only for datagen output");
        }

        public RecipeSerializer<?> getSerializer() {
            return serializers.computeIfAbsent(this.getType(), t -> Serializer.create(this.wrapped));
        }

        public RecipeType<?> getType() {
            return this.wrapped.getType();
        }

        private record Serializer(MapCodec<Recipe<?>> wrappedCodec) implements RecipeSerializer<ModdedCookingRecipeOutputShim>
        {
            private static Serializer create(Recipe<?> wrapped) {
                MappedRegistryAccessor mra;
                RecipeSerializer wrappedSerializer = wrapped.getSerializer();
                Serializer serializer = new Serializer(wrappedSerializer.codec());
                Registry registry = BuiltInRegistries.RECIPE_SERIALIZER;
                if (!(registry instanceof MappedRegistryAccessor)) {
                    throw new AssertionError((Object)("ModdedCookingRecipeOutputShim will not be able to serialize without injecting into a registry. Expected BuiltInRegistries.RECIPE_SERIALIZER to be of class MappedRegistry, is of class " + String.valueOf(BuiltInRegistries.RECIPE_SERIALIZER.getClass())));
                }
                MappedRegistryAccessor mra$ = mra = (MappedRegistryAccessor)registry;
                int wrappedId = mra$.getToId().getOrDefault((Object)wrappedSerializer, -1);
                ResourceKey wrappedKey = ((Holder.Reference)mra$.getByValue().get(wrappedSerializer)).key();
                mra$.getToId().put((Object)serializer, wrappedId);
                mra$.getByValue().put(serializer, Holder.Reference.createStandAlone(null, (ResourceKey)wrappedKey));
                return serializer;
            }

            public MapCodec<ModdedCookingRecipeOutputShim> codec() {
                return RecordCodecBuilder.mapCodec(instance -> instance.group((App)this.wrappedCodec.forGetter(i -> i.wrapped), (App)FakeItemStack.CODEC.fieldOf("result").forGetter(i -> new FakeItemStack(i.overrideID))).apply((Applicative)instance, (wrappedRecipe, fakeItemStack) -> {
                    throw new AssertionError((Object)"Only for datagen output");
                }));
            }

            public StreamCodec<RegistryFriendlyByteBuf, ModdedCookingRecipeOutputShim> streamCodec() {
                throw new AssertionError((Object)"Only for datagen output");
            }
        }

        private record FakeItemStack(ResourceLocation id) {
            public static Codec<FakeItemStack> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(FakeItemStack::id)).apply((Applicative)instance, FakeItemStack::new));
        }
    }
}

