/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.i_architecture.datagen.recipes;

import com.drmangotea.i_architecture.IndustrializedArchitecture;
import com.drmangotea.i_architecture.registry.IABlocks;
import com.drmangotea.i_architecture.registry.IAItems;
import com.simibubi.create.AllTags;
import com.simibubi.create.api.data.recipe.ProcessingRecipeGen;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class IARecipeProvider
extends RecipeProvider {
    static final List<ProcessingRecipeGen<?, ?, ?>> GENERATORS = new ArrayList();
    protected final List<GeneratedRecipe> all = new ArrayList<GeneratedRecipe>();

    public IARecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void buildRecipes(@NotNull RecipeOutput pRecipeOutput) {
        this.all.forEach(c -> c.register(pRecipeOutput));
        IndustrializedArchitecture.LOGGER.info("{} registered {} recipe{}", new Object[]{this.getName(), this.all.size(), this.all.size() == 1 ? "" : "s"});
    }

    protected GeneratedRecipe register(GeneratedRecipe recipe) {
        this.all.add(recipe);
        return recipe;
    }

    @FunctionalInterface
    public static interface GeneratedRecipe {
        public void register(RecipeOutput var1);
    }

    public static class I {
        public static ItemLike darkBrick() {
            return (ItemLike)IAItems.DARK_BRICK.get();
        }

        public static ItemLike sootBrick() {
            return (ItemLike)IAItems.SOOT_BRICK.get();
        }

        public static ItemLike ashBrick() {
            return (ItemLike)IAItems.ASH_BRICK.get();
        }

        public static ItemLike sandyBrick() {
            return (ItemLike)IAItems.SANDY_BRICK.get();
        }

        public static ItemLike muddyBrick() {
            return (ItemLike)IAItems.MUDDY_BRICK.get();
        }

        public static ItemLike roofShingle() {
            return (ItemLike)IAItems.ROOF_SHINGLE.get();
        }

        public static ItemLike foggyGlassTiles() {
            return (ItemLike)IAItems.FOGGY_GLASS_TILE.get();
        }

        public static ItemLike ceramicTile() {
            return (ItemLike)IAItems.CERAMIC_TILE.get();
        }

        public static ItemLike metalPlateBlock() {
            return IABlocks.METAL_PLATE_BLOCK.getNormal();
        }

        public static ItemLike brassPlating() {
            return IABlocks.BRASS_PLATING;
        }

        public static TagKey<Item> industrialIron() {
            return AllTags.commonItemTag((String)"ingots/industrial_iron");
        }
    }

    public static class Marker {
    }
}

