/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.i_architecture.content.blocks.railings;

import com.drmangotea.i_architecture.IndustrializedArchitecture;
import com.drmangotea.i_architecture.base.RustedBlockVariants;
import com.drmangotea.i_architecture.registry.IAShapes;
import com.simibubi.create.foundation.data.AssetLookup;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;
import org.jetbrains.annotations.Nullable;

public class RailingBlock
extends Block {
    public static final BooleanProperty NORTH = BlockStateProperties.NORTH;
    public static final BooleanProperty SOUTH = BlockStateProperties.SOUTH;
    public static final BooleanProperty WEST = BlockStateProperties.WEST;
    public static final BooleanProperty EAST = BlockStateProperties.EAST;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final VoxelShape SHAPE_WEST = Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
    public static final VoxelShape SHAPE_NORTH = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    public static final VoxelShape SHAPE_EAST = Block.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape SHAPE_SOUTH = Block.box((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);

    public RailingBlock(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{NORTH, SOUTH, WEST, EAST, WATERLOGGED});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction facing = context.getNearestLookingDirection();
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        boolean flag = fluidstate.getType() == Fluids.WATER;
        BlockState state = this.defaultBlockState();
        state = (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
        Direction direction = context.getHorizontalDirection();
        BooleanProperty property = this.getPropertyFromFacing(facing);
        if (property == null) {
            property = this.getPropertyFromFacing(context.getHorizontalDirection());
        }
        return (BlockState)super.getStateForPlacement(context).setValue((Property)property, (Comparable)Boolean.valueOf(true));
    }

    public BooleanProperty getPropertyFromFacing(Direction facing) {
        return switch (facing) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> null;
            case Direction.UP -> null;
            case Direction.NORTH -> NORTH;
            case Direction.SOUTH -> SOUTH;
            case Direction.WEST -> WEST;
            case Direction.EAST -> EAST;
        };
    }

    public VoxelShape getShape(BlockState state, BlockGetter p_54562_, BlockPos p_54563_, CollisionContext p_54564_) {
        VoxelShape shape = IAShapes.EMPTY;
        if (((Boolean)state.getValue((Property)NORTH)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)SHAPE_NORTH);
        }
        if (((Boolean)state.getValue((Property)SOUTH)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)SHAPE_SOUTH);
        }
        if (((Boolean)state.getValue((Property)WEST)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)SHAPE_WEST);
        }
        if (((Boolean)state.getValue((Property)EAST)).booleanValue()) {
            shape = Shapes.or((VoxelShape)shape, (VoxelShape)SHAPE_EAST);
        }
        return shape;
    }

    public FluidState getFluidState(BlockState p_51475_) {
        return (Boolean)p_51475_.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(p_51475_);
    }

    protected BlockState updateShape(BlockState p_54440_, Direction p_54441_, BlockState p_54442_, LevelAccessor p_54443_, BlockPos p_54444_, BlockPos p_54445_) {
        if (((Boolean)p_54440_.getValue((Property)WATERLOGGED)).booleanValue()) {
            p_54443_.scheduleTick(p_54444_, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)p_54443_));
        }
        return p_54440_;
    }

    public static NonNullBiConsumer<DataGenContext<Block, RailingBlock>, RegistrateBlockstateProvider> railing(String name) {
        return (c, p) -> {
            ResourceLocation texture = IndustrializedArchitecture.asResource("block/metal/" + name + "_railing");
            ((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent("block/" + c.getName() + "/block_railing", IndustrializedArchitecture.asResource("block/metal_railing/block_railing"))).texture("0", texture)).texture("particle", texture);
            ((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent("block/" + c.getName() + "/block_railing_higher", IndustrializedArchitecture.asResource("block/metal_railing/block_railing_higher"))).texture("0", texture)).texture("particle", texture);
            ((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent("block/" + c.getName() + "/item", IndustrializedArchitecture.asResource("block/metal_railing/item"))).texture("0", texture)).texture("particle", texture);
            ModelFile side = AssetLookup.partialBaseModel((DataGenContext)c, (RegistrateBlockstateProvider)p, (String[])new String[]{"railing"});
            ModelFile side_higher = AssetLookup.partialBaseModel((DataGenContext)c, (RegistrateBlockstateProvider)p, (String[])new String[]{"railing_higher"});
            ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)p.getMultipartBuilder((Block)c.get()).part().modelFile(side_higher).addModel()).condition((Property)NORTH, (Comparable[])new Boolean[]{true}).end().part().modelFile(side).rotationY(90).addModel()).condition((Property)EAST, (Comparable[])new Boolean[]{true}).end().part().modelFile(side_higher).rotationY(180).addModel()).condition((Property)SOUTH, (Comparable[])new Boolean[]{true}).end().part().modelFile(side).rotationY(270).addModel()).condition((Property)WEST, (Comparable[])new Boolean[]{true}).end();
        };
    }

    public static NonNullBiConsumer<DataGenContext<Block, RailingBlock>, RegistrateBlockstateProvider> metalRailing(String variant) {
        return (c, p) -> {
            if (!Objects.equals(variant, RustedBlockVariants.RustedVariants.NORMAL.getName())) {
                String variantWithoutUnderscore = variant.isEmpty() ? variant : variant.substring(0, variant.length() - 1);
                ResourceLocation texture = IndustrializedArchitecture.asResource("block/metal/" + variantWithoutUnderscore + "/" + variant + "metal_railing");
                ((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent("block/" + c.getName() + "/block_railing", IndustrializedArchitecture.asResource("block/metal_railing/block_railing"))).texture("0", texture)).texture("particle", texture);
                ((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent("block/" + c.getName() + "/block_railing_higher", IndustrializedArchitecture.asResource("block/metal_railing/block_railing_higher"))).texture("0", texture)).texture("particle", texture);
                ((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent("block/" + c.getName() + "/item", IndustrializedArchitecture.asResource("block/metal_railing/item"))).texture("0", texture)).texture("particle", texture);
            }
            ModelFile side = AssetLookup.partialBaseModel((DataGenContext)c, (RegistrateBlockstateProvider)p, (String[])new String[]{"railing"});
            ModelFile side_higher = AssetLookup.partialBaseModel((DataGenContext)c, (RegistrateBlockstateProvider)p, (String[])new String[]{"railing_higher"});
            ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)p.getMultipartBuilder((Block)c.get()).part().modelFile(side_higher).addModel()).condition((Property)NORTH, (Comparable[])new Boolean[]{true}).end().part().modelFile(side).rotationY(90).addModel()).condition((Property)EAST, (Comparable[])new Boolean[]{true}).end().part().modelFile(side_higher).rotationY(180).addModel()).condition((Property)SOUTH, (Comparable[])new Boolean[]{true}).end().part().modelFile(side).rotationY(270).addModel()).condition((Property)WEST, (Comparable[])new Boolean[]{true}).end();
        };
    }
}

