/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.i_architecture.base;

import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import net.minecraft.world.level.block.Block;

public class RustedBlockVariants<T extends Block>
implements Iterable<BlockEntry<T>> {
    private static final int VARIANT_AMOUNT = RustedVariants.values().length;
    private final BlockEntry<?>[] values = new BlockEntry[VARIANT_AMOUNT];

    public RustedBlockVariants(Function<RustedVariants, BlockEntry<? extends T>> filler) {
        for (RustedVariants variant : RustedVariants.values()) {
            this.values[variant.ordinal()] = filler.apply(variant);
        }
    }

    public BlockEntry<?>[] getValues() {
        return this.values;
    }

    public BlockEntry<T> getNormal() {
        return this.get(RustedVariants.NORMAL);
    }

    public BlockEntry<T> getSlightlyRusted() {
        return this.get(RustedVariants.SLIGHTLY_RUSTED);
    }

    public BlockEntry<T> getRusted() {
        return this.get(RustedVariants.RUSTED);
    }

    public BlockEntry<T> get(RustedVariants variant) {
        return this.values[variant.ordinal()];
    }

    public boolean contains(Block block) {
        for (BlockEntry<?> entry : this.values) {
            if (!entry.is((Object)block)) continue;
            return true;
        }
        return false;
    }

    public BlockEntry<T>[] toArray() {
        return Arrays.copyOf(this.values, this.values.length);
    }

    @Override
    public Iterator<BlockEntry<T>> iterator() {
        return new Iterator<BlockEntry<T>>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < RustedBlockVariants.this.values.length;
            }

            @Override
            public BlockEntry<T> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return RustedBlockVariants.this.values[this.index++];
            }
        };
    }

    public static String convertToFolder(String variant) {
        if (variant == RustedVariants.RUSTED.getName()) {
            return "metal/rusted";
        }
        if (variant == RustedVariants.SLIGHTLY_RUSTED.getName()) {
            return "metal/slightly_rusted";
        }
        if (variant == RustedVariants.NORMAL.getName()) {
            return "metal";
        }
        return "";
    }

    public static enum RustedVariants {
        NORMAL(""),
        SLIGHTLY_RUSTED("slightly_rusted_"),
        RUSTED("rusted_");

        private final String name;

        private RustedVariants(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

