/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.i_architecture.base;

import com.drmangotea.i_architecture.IndustrializedArchitecture;
import com.drmangotea.i_architecture.base.IAVanillaBlockStates;
import com.drmangotea.i_architecture.base.MaterialSet;
import com.drmangotea.i_architecture.base.RustedBlockVariants;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.data.ModelGen;
import com.simibubi.create.foundation.data.TagGen;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.util.DataIngredient;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.neoforged.neoforge.client.model.generators.ModelFile;

public class IAUtils {
    public static final String BRICKS = "bricks";
    public static final String METAL = "metal";
    public static final String SLIGHTLY_RUSTED_METAL = "metal/slightly_rusted";
    public static final String RUSTED_METAL = "metal/rusted";
    public static final String CERAMIC = "ceramic";

    public static void makeVariants(RustedBlockVariants<?> variants) {
        for (int i = 0; i < 3; ++i) {
            IAUtils.makeVariants(variants.getValues()[i], i == 0 ? METAL : (i == 1 ? SLIGHTLY_RUSTED_METAL : RUSTED_METAL));
        }
    }

    public static MaterialSet makeVariants(BlockEntry<?> blockEntry, String category) {
        MaterialSet materialSet = new MaterialSet();
        materialSet.block = blockEntry;
        String name = blockEntry.getId().toString().replace("i_architecture:", "");
        materialSet.wall = ((BlockBuilder)((ItemBuilder)((BlockBuilder)IndustrializedArchitecture.REGISTRATE.block(name + "_wall", WallBlock::new).initialProperties(() -> (Block)blockEntry.get()).transform(TagGen.pickaxeOnly())).blockstate((c, p) -> IAVanillaBlockStates.generateWallBlockState((DataGenContext<Block, WallBlock>)c, p, (String)(category.isEmpty() ? name : category + "/" + name))).tag(new TagKey[]{BlockTags.NEEDS_STONE_TOOL}).tag(new TagKey[]{BlockTags.WALLS}).recipe((c, p) -> {
            p.stonecutting(DataIngredient.items((ItemLike)blockEntry.asItem(), (ItemLike[])new Item[0]), RecipeCategory.BUILDING_BLOCKS, () -> ((DataGenContext)c).get(), 6);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)c.get()), (int)6).pattern("   ").pattern("AAA").pattern("AAA").define(Character.valueOf('A'), (ItemLike)blockEntry).unlockedBy("has_" + c.getName(), RegistrateRecipeProvider.has((ItemLike)((ItemLike)c.get()))).save((RecipeOutput)p, IndustrializedArchitecture.asResource("crafting/" + c.getName()));
        }).item().transform(b -> IAVanillaBlockStates.transformWallItem((ItemBuilder<BlockItem, BlockBuilder<WallBlock, CreateRegistrate>>)b, (String)(category.isEmpty() ? name : category + "/" + name)))).build()).register();
        materialSet.slab = ((BlockBuilder)((BlockBuilder)IndustrializedArchitecture.REGISTRATE.block(name + "_slab", SlabBlock::new).initialProperties(() -> (Block)blockEntry.get()).properties(p -> p.requiresCorrectToolForDrops()).transform(TagGen.pickaxeOnly())).blockstate((ctx, p) -> IAVanillaBlockStates.generateSlabBlockState((DataGenContext<Block, SlabBlock>)ctx, p, name, category)).tag(new TagKey[]{BlockTags.NEEDS_STONE_TOOL}).tag(new TagKey[]{BlockTags.SLABS}).recipe((c, p) -> {
            p.stonecutting(DataIngredient.items((ItemLike)blockEntry.asItem(), (ItemLike[])new Item[0]), RecipeCategory.BUILDING_BLOCKS, () -> ((DataGenContext)c).get(), 2);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)c.get()), (int)6).pattern("   ").pattern("AAA").pattern("   ").define(Character.valueOf('A'), (ItemLike)blockEntry).unlockedBy("has_" + c.getName(), RegistrateRecipeProvider.has((ItemLike)((ItemLike)c.get()))).save((RecipeOutput)p, IndustrializedArchitecture.asResource("crafting/" + c.getName()));
        }).item().transform(ModelGen.customItemModel((String[])new String[]{name + "_bottom"}))).register();
        materialSet.stairs = ((BlockBuilder)((BlockBuilder)IndustrializedArchitecture.REGISTRATE.block(name + "_stairs", p -> new StairBlock(blockEntry.getDefaultState(), p)).initialProperties(() -> Blocks.STONE).transform(TagGen.pickaxeOnly())).blockstate((c, p) -> IAVanillaBlockStates.generateStairBlockState((DataGenContext<Block, StairBlock>)c, p, name, category)).tag(new TagKey[]{BlockTags.NEEDS_STONE_TOOL}).tag(new TagKey[]{BlockTags.STAIRS}).recipe((c, p) -> {
            p.stonecutting(DataIngredient.items((ItemLike)blockEntry.asItem(), (ItemLike[])new Item[0]), RecipeCategory.BUILDING_BLOCKS, () -> ((DataGenContext)c).get(), 1);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)c.get()), (int)3).pattern("A  ").pattern("AA ").pattern("AAA").define(Character.valueOf('A'), (ItemLike)blockEntry).unlockedBy("has_" + c.getName(), RegistrateRecipeProvider.has((ItemLike)((ItemLike)c.get()))).save((RecipeOutput)p, IndustrializedArchitecture.asResource("crafting/" + c.getName()));
        }).item().transform(ModelGen.customItemModel((String[])new String[]{name + "_stairs"}))).register();
        return materialSet;
    }

    public static <T extends Block> NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> iASimpleBlockState(String category) {
        return (ctx, prov) -> prov.simpleBlock((Block)ctx.getEntry(), (ModelFile)prov.models().cubeAll(ctx.getName(), IndustrializedArchitecture.asResource("block/" + category + "/" + ctx.getName())));
    }

    public static String getPath(String name, String category) {
        return category + "/" + name;
    }
}

