/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.chunkloaders.capability;

import com.supermartijn642.chunkloaders.ChunkLoaderType;
import com.supermartijn642.chunkloaders.capability.ChunkLoaderCache;
import com.supermartijn642.chunkloaders.capability.ChunkLoadingCapability;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class ClientChunkLoadingCapability
extends ChunkLoadingCapability {
    public ClientChunkLoadingCapability(Level level) {
        super(level);
    }

    public void addChunkLoader(BlockPos pos, UUID owner, ChunkLoaderType type) {
        ChunkPos chunkPos = new ChunkPos(pos);
        this.chunkLoadersPerChunk.putIfAbsent(chunkPos, new HashSet());
        ((Set)this.chunkLoadersPerChunk.get(chunkPos)).add(pos);
        this.chunkLoadersPerPlayer.putIfAbsent(owner, new HashSet());
        ((Set)this.chunkLoadersPerPlayer.get(owner)).add(pos);
        this.chunkLoaderCacheMap.put(pos, new ChunkLoaderCache(pos, type, owner));
        int centerChunkX = pos.getX() >> 4;
        int centerChunkZ = pos.getZ() >> 4;
        int range = type.getRange();
        this.availableChunksPerPlayer.putIfAbsent(owner, new HashSet());
        for (int x = -range + 1; x < range; ++x) {
            for (int z = -range + 1; z < range; ++z) {
                ((Set)this.availableChunksPerPlayer.get(owner)).add(new ChunkPos(centerChunkX + x, centerChunkZ + z));
            }
        }
    }

    public void removeChunkLoader(BlockPos pos, UUID owner, ChunkLoaderType type) {
        ChunkPos chunkPos = new ChunkPos(pos);
        Set chunkLoadersPerChunk = (Set)this.chunkLoadersPerChunk.get(chunkPos);
        if (chunkLoadersPerChunk != null && chunkLoadersPerChunk.contains(pos)) {
            chunkLoadersPerChunk.remove(pos);
            if (chunkLoadersPerChunk.isEmpty()) {
                this.chunkLoadersPerChunk.remove(chunkPos);
            }
            Set chunkLoadersPerPlayer = (Set)this.chunkLoadersPerPlayer.get(owner);
            chunkLoadersPerPlayer.remove(pos);
            if (chunkLoadersPerPlayer.isEmpty()) {
                this.chunkLoadersPerPlayer.remove(owner);
            }
            this.chunkLoaderCacheMap.remove(pos);
            Set loadedChunksPerPlayer = (Set)this.loadedChunksPerPlayer.get(owner);
            Set availableChunksPerPlayer = (Set)this.availableChunksPerPlayer.get(owner);
            int radius = type.getRange();
            for (int x = -radius + 1; x < radius; ++x) {
                block1: for (int z = -radius + 1; z < radius; ++z) {
                    Set players;
                    Set inactivePlayer;
                    ChunkPos otherChunk = new ChunkPos(chunkPos.x + x, chunkPos.z + z);
                    if (this.chunkLoadersPerPlayer.containsKey(owner)) {
                        for (BlockPos chunkLoaderPos : (Set)this.chunkLoadersPerPlayer.get(owner)) {
                            int chunkLoaderChunkX = chunkLoaderPos.getX() >> 4;
                            int chunkLoaderChunkZ = chunkLoaderPos.getZ() >> 4;
                            ChunkLoaderType otherType = ((ChunkLoaderCache)this.chunkLoaderCacheMap.get((Object)chunkLoaderPos)).chunkLoaderType;
                            if (Math.abs(chunkLoaderChunkX - otherChunk.x) >= otherType.getRange() || Math.abs(chunkLoaderChunkZ - otherChunk.z) >= otherType.getRange()) continue;
                            continue block1;
                        }
                    }
                    if ((inactivePlayer = (Set)this.inactivePlayersPerLoadedChunk.get(chunkPos)) != null) {
                        inactivePlayer.remove(owner);
                        if (inactivePlayer.isEmpty()) {
                            this.inactivePlayersPerLoadedChunk.remove(chunkPos);
                        }
                    }
                    if ((players = (Set)this.activePlayersPerLoadedChunk.get(chunkPos)) != null) {
                        players.remove(owner);
                        if (players.isEmpty()) {
                            this.activePlayersPerLoadedChunk.remove(chunkPos);
                        }
                    }
                    if (loadedChunksPerPlayer != null) {
                        loadedChunksPerPlayer.remove(otherChunk);
                    }
                    if (availableChunksPerPlayer == null) continue;
                    availableChunksPerPlayer.remove(otherChunk);
                }
            }
            if (loadedChunksPerPlayer != null && loadedChunksPerPlayer.isEmpty()) {
                this.loadedChunksPerPlayer.remove(owner);
            }
            if (availableChunksPerPlayer != null && availableChunksPerPlayer.isEmpty()) {
                this.availableChunksPerPlayer.remove(owner);
            }
        }
    }

    public void startLoadingChunk(UUID player, ChunkPos chunkPos, boolean active) {
        if (active) {
            this.activePlayersPerLoadedChunk.putIfAbsent(chunkPos, new HashSet());
            ((Set)this.activePlayersPerLoadedChunk.get(chunkPos)).add(player);
        } else {
            this.inactivePlayersPerLoadedChunk.putIfAbsent(chunkPos, new HashSet());
            ((Set)this.inactivePlayersPerLoadedChunk.get(chunkPos)).add(player);
        }
        this.loadedChunksPerPlayer.putIfAbsent(player, new HashSet());
        ((Set)this.loadedChunksPerPlayer.get(player)).add(chunkPos);
    }

    public void stopLoadingChunk(UUID player, ChunkPos chunkPos) {
        Set loadedChunksPerPlayer;
        Set players;
        Set inactivePlayer = (Set)this.inactivePlayersPerLoadedChunk.get(chunkPos);
        if (inactivePlayer != null) {
            inactivePlayer.remove(player);
            if (inactivePlayer.isEmpty()) {
                this.inactivePlayersPerLoadedChunk.remove(chunkPos);
            }
        }
        if ((players = (Set)this.activePlayersPerLoadedChunk.get(chunkPos)) != null) {
            players.remove(player);
            if (players.isEmpty()) {
                this.activePlayersPerLoadedChunk.remove(chunkPos);
            }
        }
        if ((loadedChunksPerPlayer = (Set)this.loadedChunksPerPlayer.get(player)) != null) {
            loadedChunksPerPlayer.remove(chunkPos);
            if (loadedChunksPerPlayer.isEmpty()) {
                this.loadedChunksPerPlayer.remove(player);
            }
        }
    }

    public void togglePlayerActivity(UUID player, boolean active) {
        block8: {
            Set chunks = (Set)this.loadedChunksPerPlayer.get(player);
            if (chunks == null) break block8;
            if (active) {
                for (ChunkPos chunk : chunks) {
                    Set inactivePlayers = (Set)this.inactivePlayersPerLoadedChunk.get(chunk);
                    if (inactivePlayers != null) {
                        inactivePlayers.remove(player);
                        if (inactivePlayers.isEmpty()) {
                            this.inactivePlayersPerLoadedChunk.remove(chunk);
                        }
                    }
                    this.activePlayersPerLoadedChunk.putIfAbsent(chunk, new HashSet());
                    ((Set)this.activePlayersPerLoadedChunk.get(chunk)).add(player);
                }
            } else {
                for (ChunkPos chunk : chunks) {
                    Set activePlayers = (Set)this.activePlayersPerLoadedChunk.get(chunk);
                    if (activePlayers != null) {
                        activePlayers.remove(player);
                        if (activePlayers.isEmpty()) {
                            this.activePlayersPerLoadedChunk.remove(chunk);
                        }
                    }
                    this.inactivePlayersPerLoadedChunk.putIfAbsent(chunk, new HashSet());
                    ((Set)this.inactivePlayersPerLoadedChunk.get(chunk)).add(player);
                }
            }
        }
    }

    public void readServerInfo(CompoundTag compound) {
        ListTag chunkLoaderCachesTag = compound.getList("chunkLoaderCaches", 10);
        chunkLoaderCachesTag.stream().map(CompoundTag.class::cast).map(ChunkLoaderCache::read).forEach(cache -> {
            this.chunkLoaderCacheMap.put(cache.chunkLoaderPos, cache);
            this.chunkLoadersPerChunk.putIfAbsent(cache.chunkPos, new HashSet());
            ((Set)this.chunkLoadersPerChunk.get(cache.chunkPos)).add(cache.chunkLoaderPos);
            this.chunkLoadersPerPlayer.putIfAbsent(cache.owner, new HashSet());
            ((Set)this.chunkLoadersPerPlayer.get(cache.owner)).add(cache.chunkLoaderPos);
            int range = cache.chunkLoaderType.getRange();
            this.availableChunksPerPlayer.putIfAbsent(cache.owner, new HashSet());
            for (int x = -range + 1; x < range; ++x) {
                for (int z = -range + 1; z < range; ++z) {
                    ((Set)this.availableChunksPerPlayer.get(cache.owner)).add(new ChunkPos(cache.chunkPos.x + x, cache.chunkPos.z + z));
                }
            }
        });
        ListTag loadedChunksPerActivePlayerTag = compound.getList("loadedChunksPerActivePlayer", 10);
        loadedChunksPerActivePlayerTag.stream().map(CompoundTag.class::cast).forEach(playerTag -> {
            UUID player = playerTag.getUUID("player");
            Collection chunks = Arrays.stream(playerTag.getLongArray("chunks")).mapToObj(ChunkPos::new).collect(Collectors.toList());
            this.loadedChunksPerPlayer.putIfAbsent(player, new HashSet());
            ((Set)this.loadedChunksPerPlayer.get(player)).addAll(chunks);
            for (ChunkPos chunk : chunks) {
                this.activePlayersPerLoadedChunk.putIfAbsent(chunk, new HashSet());
                ((Set)this.activePlayersPerLoadedChunk.get(chunk)).add(player);
            }
        });
        ListTag loadedChunksPerInactivePlayerTag = compound.getList("loadedChunksPerInactivePlayer", 10);
        loadedChunksPerInactivePlayerTag.stream().map(CompoundTag.class::cast).forEach(playerTag -> {
            UUID player = playerTag.getUUID("player");
            Collection chunks = Arrays.stream(playerTag.getLongArray("chunks")).mapToObj(ChunkPos::new).collect(Collectors.toList());
            this.loadedChunksPerPlayer.putIfAbsent(player, new HashSet());
            ((Set)this.loadedChunksPerPlayer.get(player)).addAll(chunks);
            for (ChunkPos chunk : chunks) {
                this.inactivePlayersPerLoadedChunk.putIfAbsent(chunk, new HashSet());
                ((Set)this.inactivePlayersPerLoadedChunk.get(chunk)).add(player);
            }
        });
    }
}

