/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.world.structures;

import com.mojang.serialization.MapCodec;
import com.thedrofdoctoring.bloodlines.Bloodlines;
import com.thedrofdoctoring.bloodlines.world.structures.BloodlineStructures;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.jetbrains.annotations.NotNull;

public class ZealotShrineStructure
extends Structure {
    public static final MapCodec<ZealotShrineStructure> CODEC = ZealotShrineStructure.simpleCodec(ZealotShrineStructure::new);

    protected ZealotShrineStructure(Structure.StructureSettings pSettings) {
        super(pSettings);
    }

    @NotNull
    public Optional<Structure.GenerationStub> findGenerationPoint(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Structure.GenerationContext context) {
        int y;
        ChunkPos chunkPos = context.chunkPos();
        int midX = chunkPos.getMiddleBlockX();
        int midZ = chunkPos.getMiddleBlockZ();
        NoiseColumn blockColumn = context.chunkGenerator().getBaseColumn(midX, midZ, context.heightAccessor(), context.randomState());
        for (y = -60; y < 10 && !blockColumn.getBlock(y + 1).is(BlockTags.AIR); ++y) {
        }
        if (y >= 10) {
            return Optional.empty();
        }
        BlockPos blockPos = new BlockPos(midX, y, midZ);
        return Optional.of(new Structure.GenerationStub(blockPos, b -> b.addPiece((StructurePiece)new ZealotShrinePiece(2, context.structureTemplateManager(), "zealot_shrine", ZealotShrineStructure.makeSettings(), blockPos))));
    }

    @NotNull
    private static StructurePlaceSettings makeSettings() {
        return new StructurePlaceSettings().setRotation(Rotation.CLOCKWISE_180).setMirror(Mirror.NONE);
    }

    @NotNull
    public StructureType<?> type() {
        return (StructureType)BloodlineStructures.ZEALOT_SHRINE_STRUCTURE.get();
    }

    public static class ZealotShrinePiece
    extends TemplateStructurePiece {
        public ZealotShrinePiece(int pGenDepth, StructureTemplateManager pStructureTemplateManager, String pTemplateName, StructurePlaceSettings pPlaceSettings, BlockPos pTemplatePosition) {
            super((StructurePieceType)BloodlineStructures.ZEALOT_SHRINE_PIECE.get(), pGenDepth, pStructureTemplateManager, Bloodlines.rl("zealot_shrine"), pTemplateName, pPlaceSettings, pTemplatePosition);
        }

        public ZealotShrinePiece(StructureTemplateManager pStructureTemplateManager, CompoundTag pTag) {
            super((StructurePieceType)BloodlineStructures.ZEALOT_SHRINE_PIECE.get(), pTag, pStructureTemplateManager, p -> ZealotShrineStructure.makeSettings());
        }

        protected void addAdditionalSaveData(@NotNull StructurePieceSerializationContext pContext, @NotNull CompoundTag pTag) {
        }

        protected void handleDataMarker(@NotNull String pName, @NotNull BlockPos pPos, @NotNull ServerLevelAccessor pLevel, @NotNull RandomSource pRandom, @NotNull BoundingBox pBox) {
        }
    }
}

