/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.world.structures;

import com.thedrofdoctoring.bloodlines.Bloodlines;
import com.thedrofdoctoring.bloodlines.world.structures.ZealotShrineStructure;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class BloodlineStructures {
    public static final DeferredRegister<StructureType<?>> STRUCTURE_TYPES = DeferredRegister.create((ResourceKey)Registries.STRUCTURE_TYPE, (String)"bloodlines");
    public static final DeferredRegister<StructurePieceType> STRUCTURE_PIECES = DeferredRegister.create((ResourceKey)Registries.STRUCTURE_PIECE, (String)"bloodlines");
    public static final DeferredHolder<StructureType<?>, StructureType<ZealotShrineStructure>> ZEALOT_SHRINE_STRUCTURE = STRUCTURE_TYPES.register("zealot_shrine", () -> () -> ZealotShrineStructure.CODEC);
    public static final DeferredHolder<StructurePieceType, StructurePieceType> ZEALOT_SHRINE_PIECE = STRUCTURE_PIECES.register("zealot_shrine", () -> ZealotShrineStructure.ZealotShrinePiece::new);
    public static final ResourceKey<Structure> ZEALOT_SHRINE = ResourceKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)Bloodlines.rl("zealot_shrine"));
    public static final ResourceKey<StructureSet> ZEALOT_SHRINE_SET = BloodlineStructures.createStructureSetKey("zealot_shrine");

    private static ResourceKey<StructureSet> createStructureSetKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.STRUCTURE_SET, (ResourceLocation)Bloodlines.rl(name));
    }

    public static void createStructureSets(BootstrapContext<StructureSet> context) {
        HolderGetter structureLookup = context.lookup(Registries.STRUCTURE);
        context.register(ZEALOT_SHRINE_SET, (Object)new StructureSet((Holder)structureLookup.getOrThrow(ZEALOT_SHRINE), (StructurePlacement)new RandomSpreadStructurePlacement(20, 10, RandomSpreadType.LINEAR, 1937195837)));
    }

    public static void createStructures(BootstrapContext<Structure> context) {
        HolderGetter lookup = context.lookup(Registries.BIOME);
        context.register(ZEALOT_SHRINE, (Object)new ZealotShrineStructure(new Structure.StructureSettings.Builder((HolderSet)lookup.getOrThrow(BiomeTags.IS_OVERWORLD)).generationStep(GenerationStep.Decoration.UNDERGROUND_DECORATION).terrainAdapation(TerrainAdjustment.BEARD_BOX).build()));
    }
}

