/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.tasks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineManager;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineSkillHandler;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.task.TaskUnlocker;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public record MaxPerkUnlocker(int minPerkPoints, int maxPerkPoints) implements TaskUnlocker
{
    public static final MapCodec<MaxPerkUnlocker> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.INT.fieldOf("maxPerkPoints").forGetter(i -> i.minPerkPoints), (App)Codec.INT.fieldOf("minPerkPoints").forGetter(i -> i.maxPerkPoints)).apply((Applicative)inst, MaxPerkUnlocker::new));

    public Component getDescription() {
        return Component.translatable((String)"text.bloodlines.max_perk_points", (Object[])new Object[]{this.minPerkPoints, this.maxPerkPoints});
    }

    public boolean isUnlocked(IFactionPlayer<?> iFactionPlayer) {
        Player entity = iFactionPlayer.asEntity();
        BloodlineSkillHandler skillHandler = BloodlineManager.get(entity).getSkillHandler();
        if (skillHandler != null) {
            int taskSkillPoints = skillHandler.getTaskSkillPoints();
            return taskSkillPoints >= this.minPerkPoints && taskSkillPoints < this.maxPerkPoints;
        }
        return true;
    }

    public MapCodec<? extends TaskUnlocker> codec() {
        return CODEC;
    }
}

