/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.tasks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineManager;
import com.thedrofdoctoring.bloodlines.tasks.BloodlineTasks;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.task.TaskUnlocker;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class BloodlineUnlocker
implements TaskUnlocker {
    public static final MapCodec<BloodlineUnlocker> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.INT.fieldOf("bloodLineLevel").forGetter(i -> i.bloodlineLevel), (App)Codec.STRING.fieldOf("bloodlineId").forGetter(i -> i.id), (App)Codec.BOOL.fieldOf("matchExactly").forGetter(i -> i.matchExactly)).apply((Applicative)inst, BloodlineUnlocker::new));
    private final int bloodlineLevel;
    private final String id;
    private final boolean matchExactly;

    public BloodlineUnlocker(int rank, ResourceLocation bloodlineId, boolean matchExactly) {
        this.bloodlineLevel = rank;
        this.id = bloodlineId.toString();
        this.matchExactly = matchExactly;
    }

    public BloodlineUnlocker(int rank, String bloodlineId, boolean matchExactly) {
        this.bloodlineLevel = rank;
        this.id = bloodlineId;
        this.matchExactly = matchExactly;
    }

    public Component getDescription() {
        return Component.translatable((String)"text.bloodlines.bloodline_unlocker", (Object[])new Object[]{this.id, this.bloodlineLevel});
    }

    public boolean isUnlocked(IFactionPlayer<?> iFactionPlayer) {
        BloodlineManager bl = BloodlineManager.get(iFactionPlayer.asEntity());
        if (bl.getBloodlineId() != null) {
            boolean correctRank = this.matchExactly ? bl.getRank() == this.bloodlineLevel : bl.getRank() >= this.bloodlineLevel;
            return bl.getBloodlineId().toString().equals(this.id) && correctRank;
        }
        return false;
    }

    public MapCodec<? extends TaskUnlocker> codec() {
        return (MapCodec)BloodlineTasks.BLOODLINE_UNLOCKER.get();
    }
}

