/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.tasks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineManager;
import com.thedrofdoctoring.bloodlines.tasks.BloodlineTasks;
import de.teamlapen.vampirism.api.VampirismRegistries;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.task.ITaskRewardInstance;
import de.teamlapen.vampirism.api.entity.player.task.TaskReward;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public record BloodlinePerkReward(int perkPoints, ResourceLocation source) implements TaskReward,
ITaskRewardInstance
{
    public static final MapCodec<BloodlinePerkReward> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.INT.fieldOf("perkPointAmount").forGetter(i -> i.perkPoints), (App)ResourceLocation.CODEC.fieldOf("source").forGetter(t -> t.source)).apply((Applicative)inst, BloodlinePerkReward::new));

    public void applyReward(IFactionPlayer<?> p) {
        p.getTaskManager().resetUniqueTask(ResourceKey.create((ResourceKey)VampirismRegistries.Keys.TASK, (ResourceLocation)this.source));
        BloodlineManager.getOpt(p.asEntity()).ifPresent(bl -> {
            bl.getSkillHandler().addSkillPoints(this.perkPoints, true);
            bl.sync(false);
        });
    }

    @NotNull
    public ITaskRewardInstance createInstance(IFactionPlayer<?> player) {
        return this;
    }

    public MapCodec<BloodlinePerkReward> codec() {
        return (MapCodec)BloodlineTasks.BLOODLINE_PERK_REWARD.get();
    }

    public Component description() {
        return Component.translatable((String)"task_reward.bloodlines.bloodline_reward").withStyle(ChatFormatting.DARK_RED);
    }
}

