/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.skills.actions.vampire.noble;

import com.thedrofdoctoring.bloodlines.Bloodlines;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineHelper;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineManager;
import com.thedrofdoctoring.bloodlines.config.CommonConfig;
import com.thedrofdoctoring.bloodlines.skills.actions.vampire.noble.NobleBloodlineAction;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.particle.GenericParticleOptions;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class NobleCelerityAction
extends NobleBloodlineAction
implements ILastingAction<IVampirePlayer> {
    public static final ResourceLocation CELERITY_SPEED_LOCATION = Bloodlines.rl("noble_celerity_speed");
    public static final ResourceLocation CELERITY_STEP_LOCATION = Bloodlines.rl("noble_celerity_step");

    public boolean activate(@NotNull IVampirePlayer vampire, IAction.ActivationContext context) {
        Player player = vampire.asEntity();
        BloodlineManager.removeModifier(player.getAttribute(Attributes.MOVEMENT_SPEED), CELERITY_SPEED_LOCATION);
        BloodlineManager.removeModifier(player.getAttribute(Attributes.STEP_HEIGHT), CELERITY_STEP_LOCATION);
        int rank = BloodlineHelper.getBloodlineRank(player);
        player.getAttribute(Attributes.MOVEMENT_SPEED).addPermanentModifier(new AttributeModifier(CELERITY_SPEED_LOCATION, ((Double)((List)CommonConfig.nobleCeleritySpeedMultipliers.get()).get(rank - 1)).doubleValue(), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        if (rank >= (Integer)CommonConfig.celerityStepAssistRank.get()) {
            player.getAttribute(Attributes.STEP_HEIGHT).addPermanentModifier(new AttributeModifier(CELERITY_STEP_LOCATION, 0.5, AttributeModifier.Operation.ADD_VALUE));
        }
        return true;
    }

    public int getCooldown(IVampirePlayer player) {
        return (Integer)CommonConfig.celerityCooldown.get() * 20;
    }

    public int getDuration(@NotNull IVampirePlayer player) {
        return (Integer)CommonConfig.celerityDuration.get() * 20;
    }

    public boolean canBeUsedBy(IVampirePlayer player) {
        return true;
    }

    public boolean isEnabled() {
        return (Boolean)CommonConfig.celerityEnabled.get();
    }

    public void onActivatedClient(IVampirePlayer vampire) {
    }

    public void onDeactivated(@NotNull IVampirePlayer vampire) {
        BloodlineManager.removeModifier(vampire.asEntity().getAttribute(Attributes.MOVEMENT_SPEED), CELERITY_SPEED_LOCATION);
        BloodlineManager.removeModifier(vampire.asEntity().getAttribute(Attributes.STEP_HEIGHT), CELERITY_STEP_LOCATION);
    }

    public void onReActivated(IVampirePlayer vampire) {
    }

    public boolean onUpdate(IVampirePlayer vampire) {
        if (!vampire.asEntity().getCommandSenderWorld().isClientSide) {
            Player player = vampire.asEntity();
            ModParticles.spawnParticlesServer((Level)player.getCommandSenderWorld(), (ParticleOptions)new GenericParticleOptions(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"generic_4"), 5, 0xD3D3D3, 0.1f), (double)player.getX(), (double)player.getY(), (double)player.getZ(), (int)3, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        }
        return false;
    }

    public boolean showHudCooldown(Player player) {
        return true;
    }

    public boolean showHudDuration(Player player) {
        return true;
    }
}

