/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.skills.actions.vampire.ectotherm;

import com.thedrofdoctoring.bloodlines.config.CommonConfig;
import com.thedrofdoctoring.bloodlines.networking.packets.from_server.ClientboundLeapPacket;
import com.thedrofdoctoring.bloodlines.skills.actions.vampire.ectotherm.EctothermBloodlineAction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;

public class EctothermDolphinLeap
extends EctothermBloodlineAction
implements ILastingAction<IVampirePlayer> {
    public boolean isEnabled() {
        return true;
    }

    protected boolean activate(IVampirePlayer iVampirePlayer, IAction.ActivationContext activationContext) {
        if (!iVampirePlayer.asEntity().isInWater()) {
            iVampirePlayer.asEntity().displayClientMessage((Component)Component.translatable((String)"skill.bloodlines.ectotherm.not_in_water"), true);
            return false;
        }
        Player player = iVampirePlayer.asEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)ClientboundLeapPacket.getInstance(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        return true;
    }

    public int getCooldown(IVampirePlayer iVampirePlayer) {
        return (Integer)CommonConfig.ectothermDolphinLeapCooldown.get() * 20;
    }

    public int getDuration(IVampirePlayer iVampirePlayer) {
        return (Integer)CommonConfig.ectothermDolphinLeapDuration.get() * 20;
    }

    public void onActivatedClient(IVampirePlayer iVampirePlayer) {
    }

    public void onDeactivated(IVampirePlayer iVampirePlayer) {
    }

    public void onReActivated(IVampirePlayer iVampirePlayer) {
    }

    public boolean onUpdate(IVampirePlayer iVampirePlayer) {
        iVampirePlayer.asEntity().fallDistance = 0.0f;
        if (!iVampirePlayer.isRemote() && iVampirePlayer.asEntity().tickCount % 50 == 0) {
            this.applyEffect(iVampirePlayer);
        }
        return false;
    }

    protected void applyEffect(IVampirePlayer vampire) {
        this.addEffectInstance((IFactionPlayer)vampire, new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 52, 1));
    }

    public boolean showHudCooldown(Player player) {
        return true;
    }

    public boolean showHudDuration(Player player) {
        return true;
    }
}

