/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.skills.actions.vampire.bloodknight;

import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.vamp.IVampSpecialAttributes;
import com.thedrofdoctoring.bloodlines.config.CommonConfig;
import com.thedrofdoctoring.bloodlines.skills.actions.vampire.bloodknight.BloodknightBloodlineAction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class BloodknightDayWalker
extends BloodknightBloodlineAction
implements ILastingAction<IVampirePlayer> {
    public boolean isEnabled() {
        return true;
    }

    public boolean activate(@NotNull IVampirePlayer vampire, IAction.ActivationContext context) {
        int drain;
        int blood = vampire.getBloodStats().getBloodLevel();
        if (blood - (drain = ((Integer)CommonConfig.bloodknightDaywalkerBaseBloodCost.get()).intValue()) <= 0) {
            vampire.asEntity().displayClientMessage((Component)Component.translatable((String)"skill.bloodlines.bloodknight_not_enough_blood").withStyle(ChatFormatting.DARK_RED), true);
            return false;
        }
        vampire.useBlood(drain, true);
        this.applyEffect(vampire);
        this.setDayWalker(vampire);
        return true;
    }

    private void setDayWalker(IVampirePlayer vamp) {
        IVampSpecialAttributes specialAttributes = (IVampSpecialAttributes)((VampirePlayer)vamp).getSpecialAttributes();
        specialAttributes.bloodlines$setDayWalker(true);
    }

    public void onActivatedClient(IVampirePlayer vampire) {
        this.setDayWalker(vampire);
    }

    public void onDeactivated(@NotNull IVampirePlayer vampire) {
        IVampSpecialAttributes specialAttributes = (IVampSpecialAttributes)((VampirePlayer)vampire).getSpecialAttributes();
        specialAttributes.bloodlines$setDayWalker(false);
        this.removePotionEffect((IFactionPlayer)vampire, (Holder)ModEffects.SUNSCREEN);
    }

    public void onReActivated(@NotNull IVampirePlayer vampire) {
        this.setDayWalker(vampire);
    }

    public boolean onUpdate(IVampirePlayer vampire) {
        if (!vampire.isRemote() && vampire.asEntity().tickCount % 20 == 0) {
            this.applyEffect(vampire);
        }
        if (!vampire.isRemote() && vampire.asEntity().tickCount % (Integer)CommonConfig.bloodknightDaywalkerTimePerBloodLoss.get() == 0) {
            int blood = vampire.getBloodStats().getBloodLevel();
            int drain = 2;
            vampire.useBlood(drain, true);
            if (blood - drain <= 0) {
                vampire.asEntity().displayClientMessage((Component)Component.translatable((String)"skill.bloodlines.bloodknight_not_enough_blood").withStyle(ChatFormatting.DARK_RED), true);
                return true;
            }
        }
        return false;
    }

    public int getCooldown(IVampirePlayer iVampirePlayer) {
        return (Integer)CommonConfig.bloodknightDaywalkerCooldown.get() * 20;
    }

    public int getDuration(IVampirePlayer iVampirePlayer) {
        return (Integer)CommonConfig.bloodknightDaywalkerDuration.get() * 20;
    }

    protected void applyEffect(IVampirePlayer vampire) {
        this.addEffectInstance((IFactionPlayer)vampire, new MobEffectInstance((Holder)ModEffects.SUNSCREEN, 22, 1, false, false, false));
    }

    public boolean showHudCooldown(Player player) {
        return true;
    }

    public boolean showHudDuration(Player player) {
        return true;
    }
}

