/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.skills.actions.vampire.bloodknight;

import com.thedrofdoctoring.bloodlines.config.CommonConfig;
import com.thedrofdoctoring.bloodlines.skills.actions.vampire.bloodknight.BloodknightBloodlineAction;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.entity.VampirismEntity;
import de.teamlapen.vampirism.util.Helper;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class BloodknightBloodExtraction
extends BloodknightBloodlineAction {
    public boolean isEnabled() {
        return true;
    }

    protected boolean activate(IVampirePlayer iVampirePlayer, IAction.ActivationContext activationContext) {
        Object t;
        ItemStack stack = iVampirePlayer.asEntity().getOffhandItem();
        Item offhand = iVampirePlayer.asEntity().getOffhandItem().getItem();
        if (offhand != Items.GLASS_BOTTLE) {
            iVampirePlayer.asEntity().displayClientMessage((Component)Component.translatable((String)"bloodlines.blood_extraction.no_bottle").withStyle(ChatFormatting.DARK_RED), true);
            return false;
        }
        Optional entity = activationContext.targetEntity();
        if (entity.isPresent() && (t = entity.get()) instanceof VampirismEntity) {
            VampirismEntity ve = (VampirismEntity)t;
            @NotNull Optional creature = ExtendedCreature.getSafe((Entity)ve);
            if (Helper.isVampire((Entity)ve) && creature.isPresent()) {
                ExtendedCreature ec = (ExtendedCreature)creature.get();
                if (!ec.canBeBitten((IVampire)iVampirePlayer)) {
                    return false;
                }
                stack.shrink(1);
                ec.setBlood(ec.getBlood() - 3);
                iVampirePlayer.asEntity().addItem(new ItemStack((ItemLike)ModItems.VAMPIRE_BLOOD_BOTTLE.get()));
                return true;
            }
        }
        return false;
    }

    public int getCooldown(IVampirePlayer iVampirePlayer) {
        return (Integer)CommonConfig.bloodknightBloodExtractionCooldown.get() * 20;
    }

    public boolean showHudCooldown(Player player) {
        return true;
    }
}

