/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.skills.actions.hunter.gravebound;

import com.thedrofdoctoring.bloodlines.blocks.entities.PhylacteryBlockEntity;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineManager;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.data.BloodlineState;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.data.BloodlinesPlayerAttributes;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.hunter.BloodlineGravebound;
import com.thedrofdoctoring.bloodlines.config.HunterBloodlinesConfig;
import com.thedrofdoctoring.bloodlines.skills.actions.hunter.gravebound.DefaultGraveboundAction;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class GraveboundSoulTransferPhylacteryAction
extends DefaultGraveboundAction {
    private static final int SOUL_TRANSFER_AMOUNT = 5;

    public boolean isEnabled() {
        return true;
    }

    protected boolean activate(IHunterPlayer iHunterPlayer, IAction.ActivationContext activationContext) {
        BloodlineGravebound.State state;
        Optional<PhylacteryBlockEntity> phylacteryOpt;
        BloodlineState bloodlineState;
        Player player = iHunterPlayer.asEntity();
        if (!BloodlinesPlayerAttributes.get((Player)player).getGraveboundData().hasPhylactery) {
            return false;
        }
        Optional<BloodlineState> stateOpt = BloodlineManager.get(player).getBloodlineState();
        if (stateOpt.isPresent() && (bloodlineState = stateOpt.get()) instanceof BloodlineGravebound.State && (phylacteryOpt = (state = (BloodlineGravebound.State)bloodlineState).tryGetPhylactery()).isPresent()) {
            PhylacteryBlockEntity phylactery = phylacteryOpt.get();
            BloodlineManager manager = BloodlineManager.get(player);
            if (phylactery.getStoredSouls() <= 0) {
                player.displayClientMessage((Component)Component.translatable((String)"text.bloodlines.phylactery_not_enough_souls"), true);
                return false;
            }
            int used = phylactery.addSouls(-5);
            int usedAfter = state.addSouls(used);
            phylactery.addSouls(5 - usedAfter);
            state.updateCache(manager.getRank());
            phylactery.setChanged();
            manager.sync(false);
        }
        return true;
    }

    @Override
    public boolean canBeUsedBy(IHunterPlayer player) {
        return BloodlinesPlayerAttributes.get((Player)player.asEntity()).getGraveboundData().hasPhylactery;
    }

    public boolean showHudCooldown(Player player) {
        return true;
    }

    public int getCooldown(IHunterPlayer iHunterPlayer) {
        return (Integer)HunterBloodlinesConfig.phylacterySoulTransferActionCooldown.get() * 20;
    }
}

