/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.skills.actions.hunter.gravebound;

import com.thedrofdoctoring.bloodlines.config.HunterBloodlinesConfig;
import com.thedrofdoctoring.bloodlines.skills.actions.hunter.gravebound.GraveboundSoulAction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;

public class GraveboundSoulInfusionAction
extends GraveboundSoulAction
implements ILastingAction<IHunterPlayer> {
    public boolean isEnabled() {
        return true;
    }

    @Override
    public int getConsumedSouls(IHunterPlayer player) {
        return (Integer)HunterBloodlinesConfig.soulInfusionSoulRequirement.get();
    }

    @Override
    protected boolean activate(IHunterPlayer iHunterPlayer, IAction.ActivationContext activationContext) {
        if (!super.activate(iHunterPlayer, activationContext)) {
            return false;
        }
        this.consumeSouls(iHunterPlayer);
        this.applyEffect(iHunterPlayer);
        iHunterPlayer.asEntity().heal(5.0f);
        return true;
    }

    protected void applyEffect(IHunterPlayer hunter) {
        this.addEffectInstance((IFactionPlayer)hunter, new MobEffectInstance(MobEffects.REGENERATION, 25, 1, false, false));
        this.addEffectInstance((IFactionPlayer)hunter, new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 25, 0, false, false));
    }

    public int getCooldown(IHunterPlayer iHunterPlayer) {
        return (Integer)HunterBloodlinesConfig.soulInfusionCooldown.get() * 20;
    }

    public int getDuration(IHunterPlayer iHunterPlayer) {
        return (Integer)HunterBloodlinesConfig.soulInfusionDuration.get() * 20;
    }

    public void onActivatedClient(IHunterPlayer iHunterPlayer) {
    }

    public void onDeactivated(IHunterPlayer iHunterPlayer) {
        this.removePotionEffect((IFactionPlayer)iHunterPlayer, MobEffects.REGENERATION);
        this.removePotionEffect((IFactionPlayer)iHunterPlayer, MobEffects.DAMAGE_RESISTANCE);
    }

    public void onReActivated(IHunterPlayer iHunterPlayer) {
    }

    public boolean onUpdate(IHunterPlayer hunter) {
        if (!hunter.isRemote() && hunter.asEntity().tickCount % 20 == 0) {
            this.applyEffect(hunter);
        }
        return false;
    }

    public boolean showHudCooldown(Player player) {
        return true;
    }
}

