/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.skills.actions.hunter.gravebound;

import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.IBloodline;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.data.BloodlinesPlayerAttributes;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.hunter.BloodlineGravebound;
import com.thedrofdoctoring.bloodlines.config.HunterBloodlinesConfig;
import com.thedrofdoctoring.bloodlines.core.BloodlinesDamageTypes;
import com.thedrofdoctoring.bloodlines.core.bloodline.BloodlineRegistry;
import com.thedrofdoctoring.bloodlines.skills.actions.hunter.gravebound.DefaultGraveboundAction;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;

public class GraveboundSoulClaimingAction
extends DefaultGraveboundAction
implements ILastingAction<IHunterPlayer> {
    public boolean isEnabled() {
        return true;
    }

    protected boolean activate(IHunterPlayer iHunterPlayer, IAction.ActivationContext activationContext) {
        BloodlinesPlayerAttributes.get((Player)iHunterPlayer.asEntity()).getGraveboundData().soulClaimingActive = true;
        return true;
    }

    public void onActivatedClient(IHunterPlayer iHunterPlayer) {
        BloodlinesPlayerAttributes.get((Player)iHunterPlayer.asEntity()).getGraveboundData().soulClaimingActive = true;
    }

    public void onDeactivated(IHunterPlayer iHunterPlayer) {
        BloodlinesPlayerAttributes.get((Player)iHunterPlayer.asEntity()).getGraveboundData().soulClaimingActive = false;
    }

    public void onReActivated(IHunterPlayer iHunterPlayer) {
        BloodlinesPlayerAttributes.get((Player)iHunterPlayer.asEntity()).getGraveboundData().soulClaimingActive = true;
    }

    public int getDuration(IHunterPlayer iHunterPlayer) {
        return (Integer)HunterBloodlinesConfig.soulClaimingDuration.get() * 20;
    }

    public boolean onUpdate(IHunterPlayer iHunterPlayer) {
        return false;
    }

    public int getCooldown(IHunterPlayer iHunterPlayer) {
        return (Integer)HunterBloodlinesConfig.soulClaimingCooldown.get() * 20;
    }

    public static void handleSoulClaiming(LivingDeathEvent event) {
        Entity sourceDamageEntity = event.getSource().getEntity();
        if (sourceDamageEntity instanceof Player) {
            Player player = (Player)sourceDamageEntity;
            if (!event.getSource().is(BloodlinesDamageTypes.DEVOUR_SOUL)) {
                boolean soulClaimingActive;
                BloodlinesPlayerAttributes atts = BloodlinesPlayerAttributes.get(player);
                IBloodline bloodline = atts.bloodline;
                boolean bl = soulClaimingActive = atts.getGraveboundData().soulClaimingActive || atts.getGraveboundData().passiveSoulClaiming;
                if (bloodline instanceof BloodlineGravebound) {
                    BloodlineGravebound gravebound = (BloodlineGravebound)bloodline;
                    if (soulClaimingActive && gravebound.canDevour((Entity)event.getEntity(), player, true, true)) {
                        gravebound.devour(event.getEntity(), player, false);
                    }
                }
            }
        }
    }

    @Override
    public boolean showInSelectAction(Player player) {
        BloodlinesPlayerAttributes atts = BloodlinesPlayerAttributes.get(player);
        return atts.bloodline == BloodlineRegistry.BLOODLINE_GRAVEBOUND.get() && !atts.getGraveboundData().passiveSoulClaiming;
    }

    public boolean showHudCooldown(Player player) {
        return true;
    }
}

