/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.skills.actions.hunter.gravebound;

import com.thedrofdoctoring.bloodlines.Bloodlines;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineManager;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.hunter.BloodlineGravebound;
import com.thedrofdoctoring.bloodlines.skills.actions.hunter.gravebound.DefaultGraveboundAction;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;

public abstract class GraveboundSoulAction
extends DefaultGraveboundAction {
    public abstract int getConsumedSouls(IHunterPlayer var1);

    public void consumeSouls(IHunterPlayer player) {
        BloodlineGravebound.State state;
        Player player2 = player.asEntity();
        if (player2 instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player2;
            if (serverPlayer.gameMode.getGameModeForPlayer() == GameType.CREATIVE) {
                return;
            }
        }
        if ((state = BloodlineGravebound.getGraveboundState(player.asEntity())) == null) {
            Bloodlines.LOGGER.warn("Unable to retrieve Gravebound state when consuming souls for player {}", (Object)player.asEntity().getDisplayName());
            return;
        }
        state.addSouls(-this.getConsumedSouls(player));
        BloodlineManager.get(player.asEntity()).sync(false);
    }

    protected boolean activate(IHunterPlayer iHunterPlayer, IAction.ActivationContext activationContext) {
        BloodlineGravebound.State state = BloodlineGravebound.getGraveboundState(iHunterPlayer.asEntity());
        if (state == null) {
            return false;
        }
        int consumed = this.getConsumedSouls(iHunterPlayer);
        if (state.getSouls() - consumed <= 0) {
            iHunterPlayer.asEntity().displayClientMessage((Component)Component.translatable((String)"skill.bloodlines.gravebound_not_enough_souls").withStyle(ChatFormatting.BLUE), true);
            return false;
        }
        return true;
    }
}

