/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.skills.actions.hunter.gravebound;

import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.data.BloodlinesPlayerAttributes;
import com.thedrofdoctoring.bloodlines.config.HunterBloodlinesConfig;
import com.thedrofdoctoring.bloodlines.skills.actions.hunter.gravebound.GraveboundSoulAction;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class GraveboundPossessionSwapAction
extends GraveboundSoulAction {
    @Override
    public int getConsumedSouls(IHunterPlayer player) {
        return (Integer)HunterBloodlinesConfig.possessionSwapSoulCost.get();
    }

    @Override
    protected boolean activate(IHunterPlayer iHunterPlayer, IAction.ActivationContext activationContext) {
        if (!super.activate(iHunterPlayer, activationContext)) {
            return false;
        }
        LivingEntity target = BloodlinesPlayerAttributes.get((Player)iHunterPlayer.asEntity()).getGraveboundData().possessedEntity;
        if (target == null) {
            return false;
        }
        Vec3 targetPos = target.position();
        Vec3 playerPos = iHunterPlayer.asEntity().position();
        playerPos = new Vec3(playerPos.x, playerPos.y, playerPos.z);
        iHunterPlayer.asEntity().teleportTo(targetPos.x, targetPos.y, targetPos.z);
        target.absMoveTo(playerPos.x, playerPos.y, playerPos.z);
        this.consumeSouls(iHunterPlayer);
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean showInSelectAction(Player player) {
        return BloodlinesPlayerAttributes.get((Player)player).getGraveboundData().possessedEntity != null;
    }

    @Override
    public boolean canBeUsedBy(IHunterPlayer player) {
        return BloodlinesPlayerAttributes.get((Player)player.asEntity()).getGraveboundData().possessedEntity != null;
    }

    public int getCooldown(IHunterPlayer iHunterPlayer) {
        return (Integer)HunterBloodlinesConfig.possessionSwapCooldown.get() * 20;
    }
}

