/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.skills.actions.hunter.gravebound;

import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineManager;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.data.BloodlinesPlayerAttributes;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.hunter.BloodlineGravebound;
import com.thedrofdoctoring.bloodlines.capabilities.other.IPossessedEntity;
import com.thedrofdoctoring.bloodlines.config.HunterBloodlinesConfig;
import com.thedrofdoctoring.bloodlines.data.BloodlinesTagsProviders;
import com.thedrofdoctoring.bloodlines.mixin.EntityInvoker;
import com.thedrofdoctoring.bloodlines.mixin.LivingEntityAccessor;
import com.thedrofdoctoring.bloodlines.networking.packets.from_client.ServerboundPossessionInputPacket;
import com.thedrofdoctoring.bloodlines.networking.packets.from_client.ServerboundPossessionInteractPacket;
import com.thedrofdoctoring.bloodlines.skills.actions.hunter.gravebound.GraveboundSoulAction;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;
import org.jetbrains.annotations.NotNull;

public class GraveboundPossessionAction
extends GraveboundSoulAction
implements ILastingAction<IHunterPlayer> {
    public boolean isEnabled() {
        return true;
    }

    @Override
    public int getConsumedSouls(IHunterPlayer player) {
        return (Integer)HunterBloodlinesConfig.possessionSoulCost.get();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected boolean activate(IHunterPlayer iHunterPlayer, IAction.ActivationContext activationContext) {
        LivingEntity living;
        if (!super.activate(iHunterPlayer, activationContext)) {
            return false;
        }
        if (!activationContext.targetEntity().isPresent()) {
            iHunterPlayer.asEntity().displayClientMessage((Component)Component.translatable((String)"text.bloodlines.possesssion_entity").withStyle(ChatFormatting.BLUE), true);
            return false;
        }
        Entity targetEntity = (Entity)activationContext.targetEntity().get();
        if (targetEntity instanceof LivingEntity && (living = (LivingEntity)targetEntity).getType().is(BloodlinesTagsProviders.BloodlinesEntityTypeTagsProvider.POSSESSION_WHITELIST)) {
            boolean poss = this.startPossession(iHunterPlayer.asEntity(), living);
            if (!poss) {
                return false;
            }
        } else {
            iHunterPlayer.asEntity().displayClientMessage((Component)Component.translatable((String)"text.bloodlines.possesssion_entity_invalid").withStyle(ChatFormatting.BLUE), true);
            return false;
        }
        this.consumeSouls(iHunterPlayer);
        return true;
    }

    public static void clearPossession(Player player) {
        BloodlinesPlayerAttributes atts = BloodlinesPlayerAttributes.get(player);
        atts.getGraveboundData().possessionActive = false;
        BloodlineGravebound.State state = BloodlineGravebound.getGraveboundState(player);
        if (state != null) {
            state.clearPossession();
        }
    }

    private boolean startPossession(Player player, LivingEntity target) {
        BloodlinesPlayerAttributes atts = BloodlinesPlayerAttributes.get(player);
        if (target.isAlive()) {
            ((IPossessedEntity)target).bloodlines$setPossessed(player);
            if (target instanceof Creeper) {
                Creeper creeper = (Creeper)target;
                creeper.setSwellDir(-1);
            }
        } else {
            return false;
        }
        atts.getGraveboundData().possessionActive = true;
        atts.getGraveboundData().possessedEntity = target;
        BloodlineGravebound.State state = BloodlineGravebound.getGraveboundState(player);
        if (state != null) {
            state.setPossession(target);
            BloodlineManager.get(player).sync(false);
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.setDeltaMovement(0.0, 0.0, 0.0);
            serverPlayer.setCamera((Entity)target);
        }
        return true;
    }

    private void endPossession(Player player) {
        BloodlineGravebound.State state;
        BloodlinesPlayerAttributes atts = BloodlinesPlayerAttributes.get(player);
        atts.getGraveboundData().possessionActive = false;
        LivingEntity entity = atts.getGraveboundData().possessedEntity;
        if (entity != null && entity.isAlive()) {
            ((IPossessedEntity)entity).bloodlines$clearPossession();
        }
        atts.getGraveboundData().possessedEntity = null;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.setCamera((Entity)player);
        }
        if ((state = BloodlineGravebound.getGraveboundState(player)) != null) {
            state.clearPossession();
            BloodlineManager.get(player).sync(false);
        }
    }

    public int getCooldown(IHunterPlayer iHunterPlayer) {
        return (Integer)HunterBloodlinesConfig.possessionCooldown.get() * 20;
    }

    public int getDuration(IHunterPlayer iHunterPlayer) {
        return (Integer)HunterBloodlinesConfig.possessionDuration.get() * 20;
    }

    public void onActivatedClient(IHunterPlayer iHunterPlayer) {
        BloodlinesPlayerAttributes.get((Player)iHunterPlayer.asEntity()).getGraveboundData().possessionActive = true;
        iHunterPlayer.asEntity().setDeltaMovement(0.0, 0.0, 0.0);
    }

    public void onDeactivated(IHunterPlayer iHunterPlayer) {
        this.endPossession(iHunterPlayer.asEntity());
    }

    public void onReActivated(IHunterPlayer iHunterPlayer) {
        BloodlinesPlayerAttributes.get((Player)iHunterPlayer.asEntity()).getGraveboundData().possessionActive = true;
    }

    public boolean onUpdate(IHunterPlayer iHunterPlayer) {
        return !BloodlinesPlayerAttributes.get((Player)iHunterPlayer.asEntity()).getGraveboundData().possessionActive;
    }

    public boolean showHudDuration(Player player) {
        return true;
    }

    public static void handlePossessionInteraaction(@NotNull Player player, @NotNull ServerboundPossessionInteractPacket packet, @NotNull LivingEntity possessed) {
        if (packet.attack()) {
            LivingEntity living;
            Entity entity;
            AABB aabb;
            Vec3 view;
            Vec3 viewPos;
            if (possessed instanceof Creeper) {
                Creeper creeper = (Creeper)possessed;
                creeper.ignite();
                return;
            }
            int dist = possessed instanceof RangedAttackMob ? 100 : 10;
            Vec3 eyePos = possessed.getEyePosition();
            EntityHitResult result = ProjectileUtil.getEntityHitResult((Entity)possessed, (Vec3)eyePos, (Vec3)(viewPos = eyePos.add(view = possessed.getViewVector(1.0f).scale((double)dist))), (AABB)(aabb = possessed.getBoundingBox().expandTowards(view).inflate(1.0)), p -> p instanceof LivingEntity, (double)dist);
            if (result != null && (entity = result.getEntity()) instanceof LivingEntity && possessed.canAttack(living = (LivingEntity)entity)) {
                if (possessed instanceof RangedAttackMob) {
                    RangedAttackMob ranged = (RangedAttackMob)possessed;
                    ranged.performRangedAttack(living, 1.0f);
                } else if (possessed.getAttributes().hasAttribute(Attributes.ATTACK_DAMAGE)) {
                    float damage = (float)possessed.getAttributeValue(Attributes.ATTACK_DAMAGE);
                    possessed.swing(InteractionHand.MAIN_HAND);
                    living.hurt(possessed.damageSources().mobAttack(possessed), damage);
                }
            }
        } else {
            int dist = 8;
            Vec3 eyePos = possessed.getEyePosition();
            Vec3 view = possessed.getViewVector(1.0f).scale((double)dist);
            Vec3 viewPos = eyePos.add(view);
            AABB aabb = possessed.getBoundingBox().expandTowards(view).inflate(1.0);
            EntityHitResult entityResult = ProjectileUtil.getEntityHitResult((Entity)possessed, (Vec3)eyePos, (Vec3)viewPos, (AABB)aabb, p -> p instanceof LivingEntity, (double)dist);
            BlockHitResult blockResult = possessed.level().clip(new ClipContext(eyePos, viewPos, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)possessed));
            if (entityResult == null || eyePos.distanceTo(blockResult.getLocation()) < eyePos.distanceTo(entityResult.getLocation())) {
                BlockPos hitPos = blockResult.getBlockPos();
                BlockState block = possessed.level().getBlockState(hitPos);
                block.useWithoutItem(possessed.level(), player, blockResult);
            }
        }
    }

    public static void handlePossessionMovement(@NotNull ServerboundPossessionInputPacket packet, @NotNull LivingEntity possessed) {
        boolean flying;
        possessed.setYHeadRot(packet.yRotHead());
        possessed.absRotateTo(packet.yRot(), packet.xRot());
        boolean bl = flying = possessed instanceof FlyingMob || possessed.isNoGravity();
        float speedFactor = flying ? 2.0f : (packet.sprint() ? 0.4f : 0.15f);
        possessed.setSprinting(packet.sprint());
        possessed.setSpeed((float)possessed.getAttributeValue(Attributes.MOVEMENT_SPEED) * speedFactor);
        float verticalMotion = 0.0f;
        if (flying && packet.shift()) {
            verticalMotion = -1.0f;
        }
        if (packet.jumping()) {
            if (flying) {
                verticalMotion = 1.0f;
            } else if (possessed.onGround()) {
                possessed.jumpFromGround();
            }
        }
        GraveboundPossessionAction.travel(new Vec3((double)packet.sideways(), (double)verticalMotion, (double)packet.forward()), possessed);
    }

    private static void travel(Vec3 pTravelVector, LivingEntity possessed) {
        boolean flag;
        if (possessed instanceof FlyingMob) {
            FlyingMob mob = (FlyingMob)possessed;
            GraveboundPossessionAction.flyingTravel(pTravelVector, mob);
            return;
        }
        double d0 = possessed.getGravity();
        boolean bl = flag = possessed.getDeltaMovement().y <= 0.0;
        if (flag && possessed.hasEffect(MobEffects.SLOW_FALLING)) {
            d0 = Math.min(d0, 0.01);
        }
        LivingEntityAccessor lAccessor = (LivingEntityAccessor)possessed;
        EntityInvoker eAccessor = (EntityInvoker)possessed;
        FluidState fluidstate = possessed.level().getFluidState(possessed.blockPosition());
        if ((possessed.isInWater() || possessed.isInFluidType(fluidstate) && fluidstate.getFluidType() != NeoForgeMod.LAVA_TYPE.value()) && lAccessor.invokeAffectedByFluids() && !possessed.canStandOnFluid(fluidstate)) {
            if (possessed.isInWater() || possessed.isInFluidType(fluidstate) && !possessed.moveInFluid(fluidstate, pTravelVector, d0)) {
                double d9 = possessed.getY();
                float f4 = possessed.isSprinting() ? 0.9f : lAccessor.invokeGetWaterSlowDown();
                float f5 = 0.02f;
                float f6 = (float)possessed.getAttributeValue(Attributes.WATER_MOVEMENT_EFFICIENCY);
                if (!possessed.onGround()) {
                    f6 *= 0.5f;
                }
                if (f6 > 0.0f) {
                    f4 += (0.54600006f - f4) * f6;
                    f5 += (possessed.getSpeed() - f5) * f6;
                }
                if (possessed.hasEffect(MobEffects.DOLPHINS_GRACE)) {
                    f4 = 0.96f;
                }
                possessed.moveRelative(f5 *= (float)possessed.getAttributeValue(NeoForgeMod.SWIM_SPEED), pTravelVector);
                possessed.move(MoverType.SELF, possessed.getDeltaMovement());
                Vec3 vec36 = possessed.getDeltaMovement();
                if (possessed.horizontalCollision && possessed.onClimbable()) {
                    vec36 = new Vec3(vec36.x, 0.2, vec36.z);
                }
                possessed.setDeltaMovement(vec36.multiply((double)f4, (double)0.8f, (double)f4));
                Vec3 vec32 = possessed.getFluidFallingAdjustedMovement(d0, flag, possessed.getDeltaMovement());
                possessed.setDeltaMovement(vec32);
                if (possessed.horizontalCollision && possessed.isFree(vec32.x, vec32.y + (double)0.6f - possessed.getY() + d9, vec32.z)) {
                    possessed.setDeltaMovement(vec32.x, (double)0.3f, vec32.z);
                }
            }
        } else if (possessed.isInLava() && lAccessor.invokeAffectedByFluids() && !possessed.canStandOnFluid(fluidstate)) {
            double d8 = possessed.getY();
            possessed.moveRelative(0.02f, pTravelVector);
            possessed.move(MoverType.SELF, possessed.getDeltaMovement());
            if (possessed.getFluidHeight(FluidTags.LAVA) <= possessed.getFluidJumpThreshold()) {
                possessed.setDeltaMovement(possessed.getDeltaMovement().multiply(0.5, (double)0.8f, 0.5));
                Vec3 vec33 = possessed.getFluidFallingAdjustedMovement(d0, flag, possessed.getDeltaMovement());
                possessed.setDeltaMovement(vec33);
            } else {
                possessed.setDeltaMovement(possessed.getDeltaMovement().scale(0.5));
            }
            if (d0 != 0.0) {
                possessed.setDeltaMovement(possessed.getDeltaMovement().add(0.0, -d0 / 4.0, 0.0));
            }
            Vec3 vec34 = possessed.getDeltaMovement();
            if (possessed.horizontalCollision && possessed.isFree(vec34.x, vec34.y + (double)0.6f - possessed.getY() + d8, vec34.z)) {
                possessed.setDeltaMovement(vec34.x, (double)0.3f, vec34.z);
            }
        } else if (possessed.isFallFlying()) {
            double d11;
            double d7;
            float f1;
            possessed.checkSlowFallDistance();
            Vec3 vec3 = possessed.getDeltaMovement();
            Vec3 vec31 = possessed.getLookAngle();
            float f = possessed.getXRot() * ((float)Math.PI / 180);
            double d1 = Math.sqrt(vec31.x * vec31.x + vec31.z * vec31.z);
            double d3 = vec3.horizontalDistance();
            double d4 = vec31.length();
            double d5 = Math.cos(f);
            d5 = d5 * d5 * Math.min(1.0, d4 / 0.4);
            vec3 = possessed.getDeltaMovement().add(0.0, d0 * (-1.0 + d5 * 0.75), 0.0);
            if (vec3.y < 0.0 && d1 > 0.0) {
                double d6 = vec3.y * -0.1 * d5;
                vec3 = vec3.add(vec31.x * d6 / d1, d6, vec31.z * d6 / d1);
            }
            if (f < 0.0f && d1 > 0.0) {
                double d10 = d3 * (double)(-Mth.sin((float)f)) * 0.04;
                vec3 = vec3.add(-vec31.x * d10 / d1, d10 * 3.2, -vec31.z * d10 / d1);
            }
            if (d1 > 0.0) {
                vec3 = vec3.add((vec31.x / d1 * d3 - vec3.x) * 0.1, 0.0, (vec31.z / d1 * d3 - vec3.z) * 0.1);
            }
            possessed.setDeltaMovement(vec3.multiply((double)0.99f, (double)0.98f, (double)0.99f));
            possessed.move(MoverType.SELF, possessed.getDeltaMovement());
            if (possessed.horizontalCollision && !possessed.level().isClientSide && (f1 = (float)((d7 = d3 - (d11 = possessed.getDeltaMovement().horizontalDistance())) * 10.0 - 3.0)) > 0.0f) {
                possessed.playSound(lAccessor.invokeGetFallDamageSound((int)f1), 1.0f, 1.0f);
                possessed.hurt(possessed.damageSources().flyIntoWall(), f1);
            }
            if (possessed.onGround() && !possessed.level().isClientSide) {
                eAccessor.invokeSetFlag(7, false);
            }
        } else {
            BlockPos blockpos = possessed.getBlockPosBelowThatAffectsMyMovement();
            float f2 = possessed.level().getBlockState(possessed.getBlockPosBelowThatAffectsMyMovement()).getFriction((LevelReader)possessed.level(), possessed.getBlockPosBelowThatAffectsMyMovement(), (Entity)possessed);
            float f3 = possessed.onGround() ? f2 * 0.91f : 0.91f;
            Vec3 vec35 = possessed.handleRelativeFrictionAndCalculateMovement(pTravelVector, f2);
            double d2 = vec35.y;
            d2 = possessed.hasEffect(MobEffects.LEVITATION) ? (d2 += (0.05 * (double)(possessed.getEffect(MobEffects.LEVITATION).getAmplifier() + 1) - vec35.y) * 0.2) : (!possessed.level().isClientSide || possessed.level().hasChunkAt(blockpos) ? (d2 -= d0) : (possessed.getY() > (double)possessed.level().getMinBuildHeight() ? -0.1 : 0.0));
            if (possessed.shouldDiscardFriction()) {
                possessed.setDeltaMovement(vec35.x, d2, vec35.z);
            } else {
                possessed.setDeltaMovement(vec35.x * (double)f3, possessed instanceof FlyingAnimal ? d2 * (double)f3 : d2 * (double)0.98f, vec35.z * (double)f3);
            }
        }
        possessed.calculateEntityAnimation(possessed instanceof FlyingAnimal);
    }

    public static void flyingTravel(Vec3 pTravelVector, FlyingMob mob) {
        if (mob.isInWater()) {
            mob.moveRelative(0.02f, pTravelVector);
            mob.move(MoverType.SELF, mob.getDeltaMovement());
            mob.setDeltaMovement(mob.getDeltaMovement().scale((double)0.8f));
        } else if (mob.isInLava()) {
            mob.moveRelative(0.02f, pTravelVector);
            mob.move(MoverType.SELF, mob.getDeltaMovement());
            mob.setDeltaMovement(mob.getDeltaMovement().scale(0.5));
        } else {
            BlockPos ground = mob.getBlockPosBelowThatAffectsMyMovement();
            float f = 0.91f;
            if (mob.onGround()) {
                f = mob.level().getBlockState(ground).getFriction((LevelReader)mob.level(), ground, (Entity)mob) * 0.91f;
            }
            float f1 = 0.16277137f / (f * f * f);
            f = 0.91f;
            if (mob.onGround()) {
                f = mob.level().getBlockState(ground).getFriction((LevelReader)mob.level(), ground, (Entity)mob) * 0.91f;
            }
            mob.moveRelative(mob.onGround() ? 0.1f * f1 : 0.02f, pTravelVector);
            mob.move(MoverType.SELF, mob.getDeltaMovement());
            mob.setDeltaMovement(mob.getDeltaMovement().scale((double)f));
        }
        mob.calculateEntityAnimation(false);
    }
}

