/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.skills.actions.hunter.gravebound;

import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineHelper;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.IBloodline;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.data.BloodlinesPlayerAttributes;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.hunter.BloodlineGravebound;
import com.thedrofdoctoring.bloodlines.config.HunterBloodlinesConfig;
import com.thedrofdoctoring.bloodlines.core.bloodline.BloodlineRegistry;
import com.thedrofdoctoring.bloodlines.skills.actions.hunter.gravebound.GraveboundSoulAction;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class GraveboundPhylacteryTeleportAction
extends GraveboundSoulAction {
    @Override
    public int getConsumedSouls(IHunterPlayer player) {
        return BloodlinesPlayerAttributes.get((Player)player.asEntity()).getGraveboundData().mistForm ? (Integer)HunterBloodlinesConfig.phylacteryTeleportMistFormSoulCost.get() : (Integer)HunterBloodlinesConfig.phylacteryTeleportRegularSoulCost.get();
    }

    @Override
    protected boolean activate(IHunterPlayer iHunterPlayer, IAction.ActivationContext activationContext) {
        if (!super.activate(iHunterPlayer, activationContext)) {
            return false;
        }
        Player player = iHunterPlayer.asEntity();
        BloodlineGravebound.State state = BloodlineGravebound.getGraveboundState(player);
        if (state == null || state.getPhylacteryPos() == null) {
            return false;
        }
        if (!player.level().dimension().location().equals((Object)state.getPhylacteryDimension())) {
            player.displayClientMessage((Component)Component.translatable((String)"skill.bloodlines.gravebound_incorrect_dimension").withStyle(ChatFormatting.BLUE), true);
            return false;
        }
        Vec3 newPosition = this.findTeleportLocation(player, state.getPhylacteryPos());
        if (newPosition == null) {
            player.displayClientMessage((Component)Component.translatable((String)"skill.bloodlines.gravebound_no_safe_location").withStyle(ChatFormatting.BLUE), true);
            return false;
        }
        player.teleportTo(newPosition.x, newPosition.y, newPosition.z);
        this.consumeSouls(iHunterPlayer);
        return true;
    }

    private Vec3 findTeleportLocation(Player player, BlockPos phylacteryPos) {
        Vec3 firstPos = DismountHelper.findSafeDismountLocation((EntityType)EntityType.PLAYER, (CollisionGetter)player.level(), (BlockPos)phylacteryPos, (boolean)true);
        if (firstPos != null) {
            return firstPos;
        }
        Level level = player.level();
        int phylacteryY = phylacteryPos.getY();
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                BlockPos phylacteryHeight = new BlockPos(phylacteryPos.getX() + x, phylacteryY, phylacteryPos.getZ() + z);
                BlockPos abovePhylactery = new BlockPos(phylacteryPos.getX() + x, phylacteryY + 1, phylacteryPos.getZ() + z);
                BlockState block = level.getBlockState(phylacteryHeight);
                if (!block.is(BlockTags.AIR) || !(block = level.getBlockState(abovePhylactery)).is(BlockTags.AIR)) continue;
                return abovePhylactery.getCenter();
            }
        }
        return null;
    }

    public boolean isEnabled() {
        return true;
    }

    public int getCooldown(IHunterPlayer iHunterPlayer) {
        return (Integer)HunterBloodlinesConfig.phylacteryTeleportCooldown.get() * 20;
    }

    @Override
    public boolean canBeUsedBy(IHunterPlayer player) {
        return BloodlinesPlayerAttributes.get((Player)player.asEntity()).getGraveboundData().hasPhylactery;
    }

    @Override
    public boolean showInSelectAction(Player player) {
        return BloodlinesPlayerAttributes.get((Player)player).getGraveboundData().hasPhylactery && BloodlineHelper.hasBloodline((IBloodline)BloodlineRegistry.BLOODLINE_GRAVEBOUND.get(), player);
    }

    public boolean showHudCooldown(Player player) {
        return false;
    }
}

