/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.skills.actions.hunter.gravebound;

import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineManager;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.data.BloodlinesPlayerAttributes;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.hunter.BloodlineGravebound;
import com.thedrofdoctoring.bloodlines.config.HunterBloodlinesConfig;
import com.thedrofdoctoring.bloodlines.core.BloodlinesAttachments;
import com.thedrofdoctoring.bloodlines.skills.actions.hunter.gravebound.DefaultGraveboundAction;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.core.ModRegistries;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.NeoForgeMod;

public class GraveboundMistFormAction
extends DefaultGraveboundAction
implements ILastingAction<IHunterPlayer> {
    public static final float MISTFORM_EYE_HEIGHT = 0.25f;
    public static final EntityDimensions MISTFORM_SIZE = EntityDimensions.fixed((float)0.3125f, (float)0.3125f).withEyeHeight(0.25f);
    private static final float PLAYER_HEIGHT = 1.8f;

    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean canBeUsedBy(IHunterPlayer player) {
        BloodlinesPlayerAttributes atts = BloodlinesPlayerAttributes.get(player.asEntity());
        return atts.getGraveboundData().mistForm;
    }

    public static int getRequiredSouls(Player player, int blRank) {
        if (BloodlinesPlayerAttributes.get((Player)player).getGraveboundData().cheaperResurrection) {
            return (Integer)((List)HunterBloodlinesConfig.reducedMistFormSoulRequirement.get()).get(blRank);
        }
        return (Integer)((List)HunterBloodlinesConfig.mistFormSoulRequirement.get()).get(blRank);
    }

    private static void setMistform(IHunterPlayer factionPlayer, boolean mistForm, boolean sync) {
        Player player = factionPlayer.asEntity();
        BloodlineGravebound.State state = BloodlineGravebound.getGraveboundState(player);
        if (state != null && sync) {
            BloodlinesPlayerAttributes.get((Player)player).getGraveboundData().mistForm = mistForm;
            state.setMistForm(mistForm);
            BloodlineManager.get(player).sync(true);
        }
        player.setForcedPose((Pose)(mistForm ? Pose.CROUCHING : null));
        player.refreshDimensions();
        if (mistForm) {
            player.setPos(player.getX(), player.getY() + (double)(1.8f - MISTFORM_SIZE.height()), player.getZ());
        } else {
            BloodlinesPlayerAttributes.get((Player)player).getGraveboundData().lastDamageSource = null;
        }
        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.LIGHTNING_BOLT_THUNDER, SoundSource.PLAYERS, 0.35f, 1.0f);
        ModParticles.spawnParticlesServer((Level)player.level(), (ParticleOptions)ParticleTypes.SOUL, (double)player.getX(), (double)player.getY(), (double)player.getZ(), (int)50, (double)0.0, (double)0.5, (double)0.0, (double)0.1f);
    }

    private void setAttributes(Player player, boolean mistForm) {
        ResourceLocation key = ModRegistries.ACTIONS.getKey((Object)this);
        if (key == null) {
            return;
        }
        if (mistForm) {
            AttributeInstance health;
            AttributeInstance fly;
            AttributeInstance armorToughness;
            AttributeInstance armor = player.getAttribute(Attributes.ARMOR);
            if (armor != null && !armor.hasModifier(key)) {
                armor.addPermanentModifier(new AttributeModifier(key, -1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
            }
            if ((armorToughness = player.getAttribute(Attributes.ARMOR_TOUGHNESS)) != null && !armorToughness.hasModifier(key)) {
                armorToughness.addPermanentModifier(new AttributeModifier(key, -1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
            }
            if ((fly = player.getAttribute(NeoForgeMod.CREATIVE_FLIGHT)) != null && !fly.hasModifier(key)) {
                fly.addPermanentModifier(new AttributeModifier(key, 1.0, AttributeModifier.Operation.ADD_VALUE));
            }
            if ((health = player.getAttribute(Attributes.MAX_HEALTH)) != null && !health.hasModifier(key)) {
                health.addPermanentModifier(new AttributeModifier(key, -0.15, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
            }
            player.getAbilities().setFlyingSpeed(((Double)HunterBloodlinesConfig.mistFormFlightSpeed.get()).floatValue());
        } else {
            Objects.requireNonNull(player.getAttribute(Attributes.ARMOR)).removeModifier(key);
            Objects.requireNonNull(player.getAttribute(Attributes.ARMOR_TOUGHNESS)).removeModifier(key);
            Objects.requireNonNull(player.getAttribute(Attributes.MAX_HEALTH)).removeModifier(key);
            Objects.requireNonNull(player.getAttribute(NeoForgeMod.CREATIVE_FLIGHT)).removeModifier(key);
            player.getAbilities().setFlyingSpeed(0.05f);
        }
        player.onUpdateAbilities();
    }

    protected boolean activate(IHunterPlayer iHunterPlayer, IAction.ActivationContext activationContext) {
        GraveboundMistFormAction.setMistform(iHunterPlayer, true, true);
        this.setAttributes(iHunterPlayer.asEntity(), true);
        return true;
    }

    public void onActivatedClient(IHunterPlayer iHunterPlayer) {
        if (!BloodlinesPlayerAttributes.get((Player)iHunterPlayer.asEntity()).getGraveboundData().mistForm) {
            GraveboundMistFormAction.setMistform(iHunterPlayer, true, false);
            this.setAttributes(iHunterPlayer.asEntity(), true);
        }
    }

    public void onDeactivated(IHunterPlayer iHunterPlayer) {
        Player player = iHunterPlayer.asEntity();
        BloodlineManager manager = BloodlineManager.get(player);
        BloodlineGravebound.State state = BloodlineGravebound.getGraveboundState(player);
        player.removeData(BloodlinesAttachments.MIST_FORM);
        int requiredSouls = GraveboundMistFormAction.getRequiredSouls(player, manager.getRank() - 1);
        if (state != null && state.getSouls() > requiredSouls) {
            state.addSouls(-requiredSouls);
            GraveboundMistFormAction.setMistform(iHunterPlayer, false, true);
            this.setAttributes(iHunterPlayer.asEntity(), false);
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.LIGHTNING_BOLT_THUNDER, SoundSource.PLAYERS, 0.35f, 1.0f);
            ModParticles.spawnParticlesServer((Level)player.level(), (ParticleOptions)ParticleTypes.SOUL, (double)player.getX(), (double)player.getY(), (double)player.getZ(), (int)50, (double)0.0, (double)0.5, (double)0.0, (double)0.1f);
        } else {
            DamageSource killingDamageSource = BloodlinesPlayerAttributes.get((Player)player).getGraveboundData().lastDamageSource;
            BloodlinesPlayerAttributes.get((Player)player).getGraveboundData().mistForm = false;
            if (killingDamageSource != null) {
                player.hurt(killingDamageSource, 1000.0f);
            } else {
                player.kill();
            }
        }
    }

    public void onReActivated(IHunterPlayer iHunterPlayer) {
        GraveboundMistFormAction.setMistform(iHunterPlayer, true, false);
        this.setAttributes(iHunterPlayer.asEntity(), true);
    }

    public int getDuration(IHunterPlayer iHunterPlayer) {
        return (Integer)HunterBloodlinesConfig.mistFormDuration.get() * 20;
    }

    public boolean onUpdate(IHunterPlayer iHunterPlayer) {
        return iHunterPlayer.asEntity().tickCount % 10 == 0 && !BloodlinesPlayerAttributes.get((Player)iHunterPlayer.asEntity()).getGraveboundData().mistForm;
    }

    @Override
    public boolean showInSelectAction(Player player) {
        BloodlinesPlayerAttributes atts = BloodlinesPlayerAttributes.get(player);
        return atts.getGraveboundData().mistForm;
    }

    public int getCooldown(IHunterPlayer iHunterPlayer) {
        if (BloodlinesPlayerAttributes.get((Player)iHunterPlayer.asEntity()).getGraveboundData().fasterResurrection) {
            return (Integer)HunterBloodlinesConfig.reducedMistFormCooldown.get() * 20;
        }
        return (Integer)HunterBloodlinesConfig.mistFormCooldown.get() * 20;
    }

    public boolean showHudCooldown(Player player) {
        return true;
    }
}

