/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.skills.actions.hunter.gravebound;

import com.thedrofdoctoring.bloodlines.config.HunterBloodlinesConfig;
import com.thedrofdoctoring.bloodlines.entity.entities.LingeringDevourEntity;
import com.thedrofdoctoring.bloodlines.skills.actions.hunter.gravebound.GraveboundSoulAction;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class GraveboundLingeringDevourAction
extends GraveboundSoulAction {
    @Override
    public int getConsumedSouls(IHunterPlayer player) {
        return (Integer)HunterBloodlinesConfig.lingeringDevourSoulCost.get();
    }

    @Override
    protected boolean activate(IHunterPlayer iHunterPlayer, IAction.ActivationContext activationContext) {
        if (!super.activate(iHunterPlayer, activationContext)) {
            return false;
        }
        Optional targetBlock = activationContext.targetBlock();
        if (targetBlock.isEmpty()) {
            return false;
        }
        BlockPos target = (BlockPos)targetBlock.get();
        LingeringDevourEntity lingeringDevour = new LingeringDevourEntity(iHunterPlayer.asEntity().getCommandSenderWorld(), target.getX(), target.getY() + 1, target.getZ());
        lingeringDevour.setOwner((LivingEntity)iHunterPlayer.asEntity());
        lingeringDevour.setParticle((ParticleOptions)ParticleTypes.SOUL);
        lingeringDevour.setRadius(4.5f);
        lingeringDevour.setDuration((Integer)HunterBloodlinesConfig.lingeringDevourDuration.get() * 20);
        lingeringDevour.setRadiusPerTick((8.0f - lingeringDevour.getRadius()) / (float)lingeringDevour.getDuration());
        lingeringDevour.addEffect(new MobEffectInstance(MobEffects.POISON, 50, 1));
        iHunterPlayer.asEntity().getCommandSenderWorld().addFreshEntity((Entity)lingeringDevour);
        this.consumeSouls(iHunterPlayer);
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    public int getCooldown(IHunterPlayer iHunterPlayer) {
        return (Integer)HunterBloodlinesConfig.lingeringDevourCooldown.get() * 20;
    }

    public boolean showHudCooldown(Player player) {
        return true;
    }
}

