/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.bloodlines.skills.actions.hunter.gravebound;

import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.BloodlineHelper;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.IBloodline;
import com.thedrofdoctoring.bloodlines.capabilities.bloodlines.data.BloodlinesPlayerAttributes;
import com.thedrofdoctoring.bloodlines.config.HunterBloodlinesConfig;
import com.thedrofdoctoring.bloodlines.core.bloodline.BloodlineRegistry;
import com.thedrofdoctoring.bloodlines.skills.actions.hunter.gravebound.GraveboundSoulAction;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import net.minecraft.world.entity.player.Player;

public class GraveboundGhostWalkAction
extends GraveboundSoulAction
implements ILastingAction<IHunterPlayer> {
    public boolean isEnabled() {
        return true;
    }

    @Override
    public int getConsumedSouls(IHunterPlayer player) {
        return (Integer)HunterBloodlinesConfig.ghostWalkSoulCost.get();
    }

    @Override
    protected boolean activate(IHunterPlayer iHunterPlayer, IAction.ActivationContext activationContext) {
        if (!super.activate(iHunterPlayer, activationContext)) {
            return false;
        }
        BloodlinesPlayerAttributes.get((Player)iHunterPlayer.asEntity()).getGraveboundData().ghostWalk = true;
        this.consumeSouls(iHunterPlayer);
        return true;
    }

    public int getCooldown(IHunterPlayer iHunterPlayer) {
        return (Integer)HunterBloodlinesConfig.ghostWalkCooldown.get() * 20;
    }

    public int getDuration(IHunterPlayer iHunterPlayer) {
        return (Integer)HunterBloodlinesConfig.ghostWalkDuration.get() * 20;
    }

    public void onActivatedClient(IHunterPlayer iHunterPlayer) {
        BloodlinesPlayerAttributes.get((Player)iHunterPlayer.asEntity()).getGraveboundData().ghostWalk = true;
    }

    public void onDeactivated(IHunterPlayer iHunterPlayer) {
        BloodlinesPlayerAttributes.get((Player)iHunterPlayer.asEntity()).getGraveboundData().ghostWalk = false;
    }

    public void onReActivated(IHunterPlayer iHunterPlayer) {
        BloodlinesPlayerAttributes.get((Player)iHunterPlayer.asEntity()).getGraveboundData().ghostWalk = true;
    }

    @Override
    public boolean canBeUsedBy(IHunterPlayer player) {
        return BloodlineHelper.hasBloodline((IBloodline)BloodlineRegistry.BLOODLINE_GRAVEBOUND.get(), player.asEntity());
    }

    public boolean onUpdate(IHunterPlayer iHunterPlayer) {
        return false;
    }

    public boolean showHudDuration(Player player) {
        return true;
    }
}

